
__all__ = ['DatabaseConnectionProvider', 'OracleDatabaseConnectionProvider', 'EDBDatabaseConnectionProvider']

from threading import local
import time


class DatabaseConnectionProvider(object):
    def __init__(self, sid, usr, pwd, host, port):
        self.connectionHolder = None
        self._sid = sid
        self._usr = usr
        self._pwd = pwd
        self._host = host
        self._port = int(port)
    
    def initDatabaseConnection(self):
        pass

    def isConnectionAlive(self, connection):
        pass
    
    def getCurrentConnection(self):
        if not self.connectionHolder:
            self.connectionHolder = DbConnectionThreadLocal()
            self.connectionHolder.connection = self.initDatabaseConnection()

        if not self.isConnectionAlive(self.connectionHolder.connection):
            print time.asctime(time.localtime(time.time())), '[Info] Try to reconnect database...'
            self.connectionHolder.connection = self.initDatabaseConnection()
        
        return self.connectionHolder.connection
    
    def cleanCurrentConnection(self):
        try:
           if self.connectionHolder:
               self.connectionHolder.connection.cursor().close()
               self.connectionHolder.connection.close()
        except Exception:
            pass
        finally:
           del self.connectionHolder
           self.connectionHolder = None
    
class DbConnectionThreadLocal(local):
    def __init__(self):
        local.__init__(self)
        self.connection = None    
        
class OracleDatabaseConnectionProvider(DatabaseConnectionProvider):
    def __init__(self, sid, usr, pwd, host, port):
        DatabaseConnectionProvider.__init__(self, sid, usr, pwd, host, port)
    
    def initDatabaseConnection(self):
        import cx_Oracle
        # wfs/Wf$1234@dbserver
        connection = cx_Oracle.connect(self._usr + "/" + self._pwd + "@" + self._host)
        return connection
    
class EDBDatabaseConnectionProvider(DatabaseConnectionProvider):
    def __init__(self, sid, usr, pwd, host, port):
        DatabaseConnectionProvider.__init__(self, sid, usr, pwd, host, port)

    def isConnectionAlive(self, connection):
        import psycopg2
        try:
            cur = connection.cursor()
            cur.execute('SELECT 1')
            return True
        except psycopg2.DatabaseError:
            print '[Warning] DB connection is abnormal.'
            return False
    
    def initDatabaseConnection(self):
        import psycopg2
        connection = psycopg2.connect(database=self._sid,user=self._usr,password=self._pwd,host=self._host,port=self._port)
        return connection    
