import os


class InstallConfigItemPathResolver(object):
    RESOLVE_ITEMS = ["ruleSets.FILENAME", "ruleSetsToDelete.FILENAME", "ruleSetsToSorting.FILENAME",
                     "contentClasses.CONTENTCLASSFILES.FILENAME",
                     "contentClassesToDelete.CONTENTCLASSFILES.FILENAME"]

    def __init__(self):
        self.pathPrefix = ""

    def resolvePaths(self, config, pathPrefix):
        self.pathPrefix = pathPrefix
        for itemAttributeTree in self.RESOLVE_ITEMS:
            ConfigItemLocator().locateItemsAndExcute(itemAttributeTree, config, self)

    def execute(self, locatedItem, lastAttributeName):
        if type(dict()) == type(locatedItem):
            if locatedItem.has_key(lastAttributeName) and locatedItem[lastAttributeName]:
                if type(list()) == type(locatedItem[lastAttributeName]):
                    for i in range(0, len(locatedItem[lastAttributeName])):
                        locatedItem[lastAttributeName][i] = self.pathPrefix + locatedItem[lastAttributeName][i]
                elif isinstance(locatedItem[lastAttributeName], basestring):
                    locatedItem[lastAttributeName] = self.pathPrefix + locatedItem[lastAttributeName]
        elif type(list()) == type(locatedItem):
            for item in locatedItem:
                self.execute(item, lastAttributeName)


class InstallScriptsPathResolver(InstallConfigItemPathResolver):
    RESOLVE_ITEMS = ["preInstallationScripts", "postInstallationScripts", "postUpgradeScripts"]
    SCRIPT_PATH = "scripts"

    def __init__(self):
        InstallConfigItemPathResolver.__init__(self)

    def resolveScriptPaths(self, config, pathPrefix):
        self.resolvePaths(config, pathPrefix + self.SCRIPT_PATH + os.sep)


class InstallDataPatchSqlFilePathResolver(InstallConfigItemPathResolver):
    RESOLVE_ITEMS = ["dataPatchSqlFiles"]
    DATAPATCH_PATH = "datapatch"

    def __init__(self):
        InstallConfigItemPathResolver.__init__(self)

    def resolveSqlFilePaths(self, config, pathPrefix):
        self.resolvePaths(config, pathPrefix + self.DATAPATCH_PATH + os.sep)


class QueriesFilePathResolver(InstallConfigItemPathResolver):
    RESOLVE_ITEMS = ["QUERY"]

    def __init__(self):
        InstallConfigItemPathResolver.__init__(self)

    def resolveSqlFilePaths(self, config, pathPrefix):
        if config.has_key("queries"):
            self.resolvePaths(config["queries"], pathPrefix)

    def execute(self, locatedItem, lastAttributeName):
        if type(locatedItem) == type({}):
            query = locatedItem["QUERY"]
            if query is None or not query.endswith(".sql"):
                return

        InstallConfigItemPathResolver.execute(self, locatedItem, lastAttributeName)


class InstallConfigFileDirResolver(object):
    """
    This class collect some folders path (`conf/`, `rpmfiles/`, `ctConf/` ),
    and set paths in the config with the correspondding key (`configFileDirs`, `rpmFilesDirs`, `ctConfigFileDirs`).
    The config and key will be use in `deploy.py`, like `self.getConfig("configFileDirs")`.
    """
    
    CONF_DIR = "conf" + os.sep
    KEY_CONFIG_FILE_DIRS = "configFileDirs"
    KEY_CONFIG_FILE_TODELETE_DIRS = "configFileToDeleteDirs"
    
    CT_CONF_DIR = "ctConf" + os.sep
    KEY_CT_CONFIG_FILE_DIRS = "ctConfigFileDirs"
    
    RPM_FILES_DIR = "rpmfiles" + os.sep
    KEY_RPM_FILES_DIR = "rpmFilesDirs"
    
    CT_RPM_FILES_DIR = "ctRpmfiles" + os.sep
    KEY_CT_RPM_FILES_DIR = "ctRpmFilesDirs"

    def resolveConfigFileDir(self, config, pathPrefix, isDelete):
        confFullPath = pathPrefix + self.CONF_DIR
        if os.path.isdir(confFullPath):
            if isDelete:
                config[self.KEY_CONFIG_FILE_TODELETE_DIRS] = [confFullPath]
            else:
                config[self.KEY_CONFIG_FILE_DIRS] = [confFullPath]

    def resolveCtConfigFileDir(self, config, pathPrefix):
        ctConfFullPath = pathPrefix + self.CT_CONF_DIR
        if os.path.isdir(ctConfFullPath):
            config[self.KEY_CT_CONFIG_FILE_DIRS] = [ctConfFullPath]

    def resolveRpmFileDir(self, config, prefix):
        rpm_files_path = prefix + self.RPM_FILES_DIR
        if os.path.isdir(rpm_files_path):
            config[self.KEY_RPM_FILES_DIR] = [rpm_files_path]

    def resolveCtRpmFileDir(self, config, prefix):
        ct_rpm_files_path = prefix + self.CT_RPM_FILES_DIR
        if os.path.isdir(ct_rpm_files_path):
            config[self.KEY_CT_RPM_FILES_DIR] = [ct_rpm_files_path]

class ConfigItemLocator(object):
    def locateItemsAndExcute(self, itemAttributeTree, config, executor):
        attributes = itemAttributeTree.split(".")
        allLocatedItems = []
        if len(attributes) == 1:
            allLocatedItems.append(config)
        else:
            self.locateItemsRecursively(allLocatedItems, attributes[0:len(attributes)-1], config)
        lastAttributeName = attributes[len(attributes)-1]
        for locatedItem in allLocatedItems:
            executor.execute(locatedItem, lastAttributeName)

    def locateItemsRecursively(self, allLocatedItems, attributes, config):
        values = self.getValuesOfAttributes(attributes[0], config)
        if len(attributes) == 1:
            allLocatedItems.extend(values)
        else:
            for value in values:
                self.locateItemsRecursively(allLocatedItems, attributes[1:len(attributes)], value)

    def getValuesOfAttributes(self, attribute, config):
        values = []
        if type(dict()) == type(config):
            if config.has_key(attribute) and config[attribute]:
                values.append(config[attribute])
        elif type(list()) == type(config):
            for item in config:
                values.extend(self.getValuesOfAttributes(attribute, item))
        return values
