import json
import os

from Common import Common
from InstallComponent import InstallComponent
from InstallComponentCollector import ComponentPathBuilder
from InstallConfigItemResolver import InstallConfigFileDirResolver
from InstallConfigItemResolver import InstallConfigItemPathResolver
from InstallConfigItemResolver import InstallDataPatchSqlFilePathResolver, QueriesFilePathResolver
from InstallConfigItemResolver import InstallScriptsPathResolver


class InstallConfigObjectConstructor(Common):
    CONFIG_JSON = "config.json"
    REMOVE_CONFIG_JSON = "remove.json"

    def __init__(self, fullInstallComponents, componentsToInstall, componentsToDelete):
        Common.__init__(self)
        self.fullInstallComponents = fullInstallComponents.resolveLeaves()
        self.componentsToDelete = componentsToDelete.resolveLeaves(self.fullInstallComponents)
        self.componentsToInstall = componentsToInstall.resolveLeaves(self.fullInstallComponents)
    
    def isInvolveNothing(self):
        return not (self.componentsToInstall.hasSubComponentExceptBase() or self.componentsToDelete.hasSubComponentExceptBase())
    
    def constructFinalJsonObj(self, pathPrefix):
        allComponentsToHandle = self.mergeAllComponentsToHandle()
        return self.mergeComponentConfigRecursively(allComponentsToHandle.getSubComponents(), pathPrefix)
    
    def mergeAllComponentsToHandle(self):
        self.resolveKeywordOfComponent(self.componentsToInstall, InstallComponent.KEYWORD_INSTALL)
        self.resolveKeywordOfComponent(self.componentsToDelete, InstallComponent.KEYWORD_DELETE)
        # notice: should use to_install merge to_delete, then the component.keyword will keep the to_install
        # even it's contained by both to_install & to_delete.
        # e.g. to_install: mf, to_delete: mr, then the downstream.keyword should be install
        return self.componentsToInstall.copy().merge(self.componentsToDelete)
    
    def resolveKeywordOfComponent(self, currentComponent, keyword):
        if currentComponent.componentName != "ROOT":
            currentComponent.setKeyword(keyword)

        if currentComponent.hasSubComponent():
            for subComponent in currentComponent.getSubComponents():
                self.resolveKeywordOfComponent(subComponent, keyword)

    def mergeComponentConfigRecursively(self, installComponents, pathPrefix):
        base = {}
        for component in installComponents:
            if component.hasSubComponent():
                base = self.mergeConfig(base, self.mergeComponentConfigRecursively(component.getSubComponents(), pathPrefix))
            actualPath = self.getActualConfigLocation(component, pathPrefix)
            
            base = self.mergeConfig(base, self.getAndModifyConfigs(actualPath, component))
        return base
                    
    def getAndModifyConfigs(self, actualPath, component):
        if not component.keyWord:
            return {}

        if component.isDelete():
            jsonPath = actualPath + self.REMOVE_CONFIG_JSON
        else:
            jsonPath = actualPath + self.CONFIG_JSON
            
        componentConfig = {}
        if os.path.exists(jsonPath):
            print 'merging file: ' + jsonPath
            json_data = open(jsonPath)
            componentConfig = json.load(json_data)
            json_data.close()
            InstallConfigItemPathResolver().resolvePaths(componentConfig, actualPath)
            InstallScriptsPathResolver().resolveScriptPaths(componentConfig, actualPath)
            InstallDataPatchSqlFilePathResolver().resolveSqlFilePaths(componentConfig, actualPath)
            QueriesFilePathResolver().resolveSqlFilePaths(componentConfig, actualPath)

        # "conf" directory is auto detected, so even no JSON file exists, we also need to do the detection
        # and add the "conf" directory to JSON object
        InstallConfigFileDirResolver().resolveConfigFileDir(componentConfig, actualPath, component.isDelete())
        InstallConfigFileDirResolver().resolveCtConfigFileDir(componentConfig, actualPath)
        InstallConfigFileDirResolver().resolveRpmFileDir(componentConfig, actualPath)
        InstallConfigFileDirResolver().resolveCtRpmFileDir(componentConfig, actualPath)
        return componentConfig
    
    def getActualConfigLocation(self, component, pathPrefix):
        return ComponentPathBuilder.getComponentsPathPrefix(pathPrefix) + component.getConfigLocation()
