#!/usr/bin/env python
from decimal import Decimal

import MeSubsProfile
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class MeFieldDefinition:
	
	def __init__(self):
		self.connection = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getCmsDatabaseConnection()
		self.cursor = self.connection.cursor()
			
	def getId(self, data):
		pass
	
	def getNextId(self):
		#statement = "SELECT MAX(ID) FROM ME_FIELD_DEFINITION" 
		statement = "select nextval('ME_FIELD_DEFINITION_SEQ')"
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		return rows[0][0]

	'''This method will only be used in upgrade scenario when unique key confilct using sequence
	'''
	def getNextIdViaMaxValue(self):
		statement = "SELECT MAX(ID) FROM ME_FIELD_DEFINITION" 
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		return rows[0][0]
	
	def insert(self, data):
		"""
		data[0]: fieldName
		data[1]: ME profile Name
		"""
		fieldName 			= data[0]
		meProfileName		= data[1]	
		mapping				= data[2]
		datatype			= data[3]
		path				= data[4]
		
		id = self.getNextId()
		meProfileId 	= self.getMeProfileId(meProfileName)
		if meProfileId == False or id == 0:
			return False
		
		try:
			statement = "INSERT INTO ME_FIELD_DEFINITION (ID,PROFILE_ID, NAME, MAPPING, DATATYPE, PATH) VALUES %s" % self.tupleToStr([id, meProfileId, fieldName, mapping, datatype, path])
			print statement
			self.cursor.execute(statement)
			return id
		except Exception, e:
			self.connection.rollback()
			print "Insert failed, retry..."
			id = self.getNextIdViaMaxValue()+1
			try:
				statement = "INSERT INTO ME_FIELD_DEFINITION (ID,PROFILE_ID, NAME, MAPPING, DATATYPE, PATH) VALUES %s" % self.tupleToStr([id, meProfileId, fieldName, mapping, datatype, path])
				print statement
				self.cursor.execute(statement)
				return id
			except Exception, e:
				print e
				return False
		
	def update(self, data):
		"""
		data[0]: fieldName
		data[1]: ME profile Name
		"""
		fieldName 			= data[0]
		meProfileName		= data[1]
		mapping				= data[2]
		datatype			= data[3]
		path				= data[4]
		
		fieldId = self.getId(data)
		
		if fieldId == False:
			return False
		
		try:
			statement = "UPDATE ME_FIELD_DEFINITION SET MAPPING='%s', DATATYPE='%s', PATH='%s' WHERE ID = %d " % (mapping, datatype, path, fieldId)
			print statement
			self.cursor.execute(statement)
		except Exception, e:
			print e
		
	def delete(self, fieldId):
		if fieldId == False:
			return
		
		statement = "DELETE FROM ME_FIELD_DEFINITION WHERE ID = %d" % fieldId
		print statement
		
		self.cursor.execute(statement)
		
	def deleteByProfile(self, profileId):
		statement = "DELETE FROM ME_FIELD_DEFINITION WHERE PROFILE_ID = %d" % profileId
		print statement
		self.cursor.execute(statement)
		
	def getMeProfileId(self, *data):
		return MeSubsProfile.MeSubsProfile().checkExistence(data)
	
	def getFields(self, fieldId):
		statement = "SELECT NAME, MAPPING, DATATYPE, PATH FROM ME_FIELD_DEFINITION WHERE ID = %d" % fieldId
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0]
		else:
			return ()		
		
	def tupleToStr(self, values):
		arr = []
		for v in values:
			if isinstance(v, basestring):
				arr.append(str(v))
			elif type(v) == type(long()):
				arr.append(int(v))
			elif isinstance(v, Decimal):
				arr.append(int(v))
			else:
				arr.append(v)
		return str(tuple(arr)).replace("None", "NULL").replace("\\\\", "\\")		


class MeCriteriaFieldDefinition(MeFieldDefinition):
	
	def __init__(self):
		MeFieldDefinition.__init__(self)
			
	def getId(self, data):
		"""
		data[0]: fieldName
		data[1]: ME profile Name
		"""
		fieldName 		= data[0]
		meProfileName	= data[1]
		
		meProfileId 	= self.getMeProfileId(meProfileName)
		if meProfileId == False:
			return False
		
		statement = "select FD.ID from ME_IDENTIFIER_CRITERIA CR " \
					"join ME_FIELD_DEFINITION FD on (FD.ID = CR.KEY_FIELD_ID)" \
					"where FD.NAME = '%s' and CR.PROFILE_ID = %d" % (fieldName, meProfileId)
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False


class MeEnhanceFieldDefinition(MeFieldDefinition):

	def __init__(self):
		MeFieldDefinition.__init__(self)
			
	def getId(self, data):
		"""
		data[0]: fieldName
		data[1]: ME profile Name
		"""
		fieldName 		= data[0]
		meProfileName	= data[1]
		
		meProfileId 	= self.getMeProfileId(meProfileName)
		if meProfileId == False:
			return False
		
		statement = "select FD.ID from ME_ENHANCED_FIELD EF " \
					"join ME_FIELD_DEFINITION FD on (FD.ID = EF.FIELD_ID)" \
					"where FD.NAME = '%s' and EF.PROFILE_ID = %d" % (fieldName, meProfileId)
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
def main():
	fieldDefinition = MeCriteriaFieldDefinition()
	
if __name__ == "__main__":
	main()
