import sys
import time

class Tee(object):
    def __init__(self, name, mode, withTimeStamp=False):
        if withTimeStamp:
            name = name + "." + time.strftime('%Y%m%d%H%M%S')
        self.file = open(name, mode)
        self.stdout = sys.stdout
        sys.stdout = self
    
    def __del__(self):
        try:
            sys.stdout = self.stdout
            self.file.close()
        except AttributeError, e:
            pass
    
    def write(self, data):
        self.file.write(data)
        self.file.flush()
        self.stdout.write(data)
        self.stdout.flush()