#!/usr/bin/env python
import getopt
import sys

import os
from lxml import etree

from CsvLikeFileHandler import CsvLikeFileHandler
from PropertiesFileHandler import PropertiesFileHandler
from XmlFileHandler import XmlFileHandler


class MigrationTool(object):
    def getCommandOpts(self):    
        try:
            opts, args = getopt.getopt(sys.argv[1:], "t:a:f:k:v:", ["type", "action", "filePath", "key", "value"])
        except getopt.GetoptError as err:
            output("MigrationTool.py [-t type -a action -f filePath -k key -v value]" + str(err))
            sys.exit(1)        
        optsDict = dict(opts)
        if optsDict.get('-t'):
            optsDict['type'] = optsDict.pop('-t')
        optsDict['action'] = optsDict.pop('-a')
        optsDict['filePath'] = optsDict.pop('-f')
        optsDict['key'] = optsDict.pop('-k')
        if optsDict.get('-v'):
            optsDict['value'] = optsDict.pop('-v')
      
        for index in optsDict:
            optsDict[index] = optsDict[index].replace('\xc2\xa0', '')                  
        return optsDict
        
    def getHandler(self, optsDict):
        filePath = optsDict['filePath']
                
        handler = None
        if not os.path.exists(filePath):
            print 'file path does not exist:', filePath
            return handler
        xmlParseError = None
        
        if 'type' in optsDict:
            type = optsDict['type']
            if type.upper() == 'XML':
                handler = XmlFileHandler(optsDict)
            if type.upper() == 'PROPERTIES':
                handler = PropertiesFileHandler(optsDict)
            if type.upper() == 'CSV':
                handler = CsvLikeFileHandler(optsDict)              
        else:    
            try:
                tree = etree.parse(filePath)
            except Exception, e:
                xmlParseError = str(e)
            if xmlParseError is None:
                handler = XmlFileHandler(optsDict)
            else:
                handler = PropertiesFileHandler(optsDict)
        return handler 


def main():
    mt = MigrationTool()
    optsDict = mt.getCommandOpts()
    handler = mt.getHandler(optsDict)
    if handler:
        handler.handle()


if __name__ == "__main__":
    main()

