#!/usr/bin/env python
from lxml import etree

from BaseHandler import BaseHandler


class XmlFileHandler(BaseHandler):
            
    def __init__(self, dictData):
        BaseHandler.__init__(self, dictData)
        self.parser = etree.XMLParser(remove_blank_text=True, resolve_entities=False)
        self.tree = etree.parse(self.filePath, self.parser)
        if self.tree:
            self.root = self.tree.getroot()
    
    def removeEntryByKey(self):
        if self.key is None:
            return
        
        entries = self.tree.xpath(self.key)
        for entry in entries:
            entry.getparent().remove(entry)
            self.tree.write(self.filePath, xml_declaration=True, pretty_print=True, encoding="UTF-8")
            print 'Remove entry:' + self.key
        
    def replaceEntryValueByKey(self):
        if self.key is None or self.value is None:
            return
        
        entries = self.tree.xpath(self.key)
        for entry in entries:
            if str(self.value).strip() != entry.text:
                entry.text = str(self.value)
                self.tree.write(self.filePath, xml_declaration=True, pretty_print=True, encoding="UTF-8")
                print 'Change the value to ' + self.value + ' for entry ' + self.key
    
    def updateEntryKeyByKey(self):
        if self.key is None or self.value is None:
            return
        
        last_index = self.key.rfind('@')
        keyName = None
        if last_index >= 0:
            keyName = self.key[last_index + 1:]
        else:
            print 'Incorrect Xpath'
            return
        entries = self.tree.xpath(self.key)
        for entry in entries:
            orig_key_value = entry.getparent().attrib[keyName]
            if str(self.value).strip() != orig_key_value:
                entry.getparent().attrib[keyName] = self.value
                self.tree.write(self.filePath, xml_declaration=True, pretty_print=True, encoding="UTF-8")
                print 'Change the key value to ' + self.value

    # The value will be added as child element
    def addEntry(self):
        if self.key is None:
            return
        entries = self.tree.xpath(self.key)
        for entry in entries:
            newEntry = etree.XML(self.value, self.parser)
            for child in entry.getchildren():
                if child.tag == newEntry.tag and child.attrib == newEntry.attrib:
                    print 'Warning: Already exists the same entry, please change action'
                    return
            entry.append(newEntry)
            self.tree.write(self.filePath, xml_declaration=True, pretty_print=True, encoding="UTF-8")
            print 'Add One Entry Succeed '
    
    def removeEntryValueByKey(self):
        if self.key is None or self.value is None:
            return
        entries = self.tree.xpath(self.key)
        for entry in entries:
            originalValue = entry.text
            if originalValue is None:
                return
            orig_value_list = str(originalValue).strip().split(",")
            for v in str(self.value).split(","):
                index = self.getIndex(orig_value_list, v)
                if index is not None:
                    orig_value_list.pop(index)
                    print 'Remove value ' + str(v) + ' for entry ' + str(self.key)
                else:
                    print 'Not found value:' + str(v)
            newValue = ','.join(orig_value_list)
            
            if newValue != originalValue:
                entry.text = newValue
                self.tree.write(self.filePath, xml_declaration=True, pretty_print=True, encoding="UTF-8")

    def appendEntryValueByKey(self):
        if self.key is None or self.value is None:
            return
        entries = self.tree.xpath(self.key)
        for entry in entries:
            originalValue = entry.text
            if originalValue is None:
                newValue = self.value
                print 'Append value: ' + self.value + ' for entry ' + str(self.key)
            else:
                orig_v_list = originalValue.split(',')
                for v in self.value.split(','):
                    if self.getIndex(orig_v_list, v) is None:
                        orig_v_list.append(str(v).strip())
                        print 'Append value ' + str(v) + ' for entry ' + str(self.key)
                newValue = ','.join(orig_v_list)   
                 
            if newValue != originalValue:
                entry.text = newValue
                self.tree.write(self.filePath, xml_declaration=True, pretty_print=True, encoding="UTF-8")    


def main():
    filePath = "C:\\Users\\echesal\\Desktop\\mapping.xml"
#     handle = XmlFileHandler(filePath)
#     data = {'filePath':filePath,'key':'/properties/profile[@name=\'verifier-evaluation1\']/entry','value':'Test replace'}
#     XmlFileHandler(data).replaceEntryValueByKey()
      
#     data1 = {'filePath':filePath,'key':'/properties/profile[@name=\'verifier-evaluation\']/entry/@key3','value':'NAME4'}
#     XmlFileHandler(data1).updateEntryKeyByKey()
  
#     data3 = {'filePath':filePath,'key':'/properties/entry', 'value':'<entry key=\"name3\">Test</entry>'}
#     XmlFileHandler(data3).addEntry()
      
#     data2 = {'filePath':filePath,'key':'/properties/profile/entry[@key=\'name3\']'}
#     XmlFileHandler(data2).removeEntryByKey()

#     data4 = {'filePath':filePath,'key':'/properties/profile/entry[@key=\'name2\']', 'value':'11,test7 ,test6'}
#     XmlFileHandler(data4).appendEntryValueByKey()
#      
#     data5 = {'filePath':filePath,'key':'/properties/profile/entry[@key=\'name2\']', 'value':'test1, test6, test7, test8'}
#     XmlFileHandler(data5).removeEntryValueByKey()


if __name__ == "__main__":
    main()
