#!/usr/bin/env bash

DEPLOYED_FILE_LIST_FROM_60="/mnt/cms-prepack/installer/upgrade/deployed-files-60"

if [[ -f $DEPLOYED_FILE_LIST_FROM_60 ]]; then
	while read path
	do
		if [[ "$path" != "/opt/tandbergtv/cms/"* ]]; then
			echo "[WARN] remove file path is illegal: $path"
		elif [[ -d "$path" ]]; then
			echo "[DEBUG] remove all files in directory: $path"
			rm -rf "${path}"
		else
			ls ${path} >/dev/null 2>&1 && echo "[DEBUG] remove file $path" && rm -f ${path}
		fi
	done < ${DEPLOYED_FILE_LIST_FROM_60}

else
	echo "[WARN] $DEPLOYED_FILE_LIST_FROM_60 not exists."
fi
