<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	version="2.0">

	<xsl:template name="AMS_1">
		<xsl:if test="Fields/Version/Major">
			<xsl:attribute name="providerVersionNum">
				<xsl:value-of select="Fields/Version/Major"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="Fields/Version/Minor">
			<xsl:attribute name="internalVersionNum">
				<xsl:value-of select="Fields/Version/Minor"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="Fields/CreationInfo/CreateDate">
			<xsl:attribute name="creationDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="Fields/CreationInfo/CreateDate"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/Fields/Rights/LicensingWindowStart">
			<xsl:attribute name="startDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowStart"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/Fields/Rights/LicensingWindowEnd">
			<xsl:attribute name="endDateTime">
				<xsl:call-template name="endDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowEnd"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="Fields/ProviderInfo/Identifier/Id and Fields/Identifier/Id">
			<core:AlternateId identifierSystem="VOD1.1">
				<xsl:value-of select="concat('vod://',Fields/ProviderInfo/Identifier/Id,'/',Fields/Identifier/Id)"/>
			</core:AlternateId>
		</xsl:if>
<!-- 		<xsl:if test="Fields/ISAN"> -->
<!-- 			<core:AlternateId identifierSystem="ISAN"> -->
<!-- 				<xsl:value-of select="Fields/ISAN"/> -->
<!-- 			</core:AlternateId> -->
<!-- 		</xsl:if> -->
	</xsl:template>

	<xsl:template name="AMS_2">
		<xsl:if test="Fields/AssetName">
			<core:AssetName deprecated="true">
				<xsl:value-of select="Fields/AssetName"/>
			</core:AssetName>
		</xsl:if>
		<xsl:if test="Fields/ProductInfo/Name">
			<core:Product deprecated="true">
				<xsl:value-of select="Fields/ProductInfo/Name"/>
			</core:Product>
		</xsl:if>		
		<xsl:if test="Fields/ProviderInfo/Name">
			<core:Provider deprecated="true">
				<xsl:value-of select="Fields/ProviderInfo/Name"/>
			</core:Provider>
		</xsl:if>
		<xsl:if test="Fields/Description/Text">
			<core:Description deprecated="true">
				<xsl:choose>
					<xsl:when test="string-length(Fields/Description/Text) > 100">
						<xsl:value-of select="substring(Fields/Description/Text, 0, 100)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Fields/Description/Text"/>
					</xsl:otherwise>
				</xsl:choose>
			</core:Description>
		</xsl:if>
		
<!-- 		<core:Ext>
			<xsl:apply-templates select="Fields/CustomFields/CustomField" />
		</core:Ext> -->
	</xsl:template>
	
	<!--AMS_3 is just for title/Category, 
		if there are multiple same asset,such as two poster asset,
		<xsl:value-of select="$assetType/Fields/Version/Major"/> will return two values, which is not make sense.
		so AMS_1 can not be reused temporarily
	-->
	<xsl:template name="AMS_3">
		<xsl:if test="$Package/Fields/Version/Major">
			<xsl:attribute name="providerVersionNum">
				<xsl:value-of select="$Package/Fields/Version/Major"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="$Package/Fields/Version/Minor">
			<xsl:attribute name="internalVersionNum">
				<xsl:value-of select="$Package/Fields/Version/Minor"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="$Package/Fields/CreationInfo/CreateDate">
			<xsl:attribute name="creationDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Package/Fields/CreationInfo/CreateDate"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/Fields/Rights/LicensingWindowStart">
			<xsl:attribute name="startDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowStart"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/Fields/Rights/LicensingWindowEnd">
			<xsl:attribute name="endDateTime">
				<xsl:call-template name="endDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowEnd"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="$Package/Fields/ProviderInfo/Identifier/Id and $Package/Fields/Identifier/Id">
			<core:AlternateId identifierSystem="VOD1.1">
				<xsl:value-of select="concat('vod://',$Package/Fields/ProviderInfo/Identifier/Id,'/',$Package/Fields/Identifier/Id)"/>
			</core:AlternateId>
		</xsl:if>
	</xsl:template>

	<xsl:template name="ContentAsset">
		<xsl:param name="masterSourceRef"/>
		<xsl:param name="assetType"/>
		<!--<xsl:attribute name="uriId"><xsl:value-of select="concat( Fields/ProviderInfo/Identifier/Id, '/Asset/', Fields/Identifier/Id )"/></xsl:attribute>-->
		<xsl:call-template name="encodeUri">
			<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
			<xsl:with-param name="assetType" select="'/Asset/'" />
			<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
		</xsl:call-template>

		<xsl:call-template name="AMS_1" />
		<xsl:call-template name="AMS_2" />
		
		<core:Ext>
			<xsl:apply-templates select="Fields/CustomFields/CustomField" />
		</core:Ext>
		
		<xsl:if test="Fields/Derived/SourceAssetId != '' and Fields/Derived/SourceProviderId != ''">
			<core:MasterSourceRef>
				<xsl:call-template name="encodeUri">
					<xsl:with-param name="providerId" select="Fields/Derived/SourceProviderId" />
					<xsl:with-param name="assetType" select="'/Asset/'" />
					<xsl:with-param name="fieldId" select="Fields/Derived/SourceAssetId" />
				</xsl:call-template>
			</core:MasterSourceRef>
		</xsl:if>
		
		<xsl:if test="Fields/Content/Locator/Uri !=''">
			<content:SourceUrl>
					<xsl:choose>
					
						<xsl:when test="Fields/CustomFields/CustomField[@name='PlayoutURL']/Value != ''">
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='PlayoutURL']/Value"/>
						</xsl:when>		
						<xsl:otherwise>
							<xsl:analyze-string select="fn:translate(Fields/Content/Locator/Uri, '/', '\')" regex=".*\\([^\\]+$)">
								<xsl:matching-substring>
									<xsl:value-of select="regex-group(1)"/>
								</xsl:matching-substring>
								<xsl:non-matching-substring>
								    <xsl:value-of select="."/>
								</xsl:non-matching-substring>
							</xsl:analyze-string>				
						</xsl:otherwise>
					</xsl:choose> 		   
			</content:SourceUrl>
		</xsl:if>
		<xsl:if test="Fields/Content/Size/length">
			<content:ContentFileSize>
				<xsl:value-of select="Fields/Content/Size/length"/>
			</content:ContentFileSize>
		</xsl:if>
		<xsl:if test="Fields/Content/Checksum">
			<content:ContentCheckSum>
				<xsl:value-of select="Fields/Content/Checksum"/>
			</content:ContentCheckSum>
		</xsl:if>
		<xsl:if test="$Title/Fields/PropagationPriority" >
			<content:PropagationPriority>
				<!-- grab any one (max??) -->
				<xsl:value-of select="$Title/Fields/PropagationPriority"/>
			</content:PropagationPriority>
		</xsl:if>
		<xsl:if test="Fields/Content/Locator/Path !=''">
			<content:ContentRef>
				<xsl:value-of select="Fields/Content/Locator/Path"/>
			</content:ContentRef>
		</xsl:if>
		<xsl:if test="Fields/Content/MIMEType">
			<content:MediaType>
				<xsl:value-of select="Fields/Content/MIMEType"/>
			</content:MediaType>
		</xsl:if>

	</xsl:template>

	<xsl:template name="startDateTime">
		<xsl:param name="dateString" />
		<xsl:choose>
			<xsl:when test="string-length($dateString) = 10"><xsl:value-of select="concat($dateString,'T00:00:00Z')"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="concat($dateString,'Z')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="endDateTime">
		<xsl:param name="dateString" />
		<xsl:choose>
			<xsl:when test="string-length($dateString) = 10"><xsl:value-of select="concat($dateString,'T23:59:59Z')"/></xsl:when>
			<xsl:when test="contains($dateString,'T00:00:00')"><xsl:value-of select="replace($dateString,'T00:00:00','T23:59:59Z')"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="concat($dateString,'Z')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*|@*" mode="stringToDuration">
		<xsl:variable name="hours" select="concat('PT',substring-before(., ':'),'H')"/>
		<xsl:variable name="remaining" select="substring-after(., ':')"/>
		<xsl:variable name="minutes" select="concat(substring-before($remaining, ':'),'M')"/>
		<xsl:variable name="seconds" select="concat(substring-after($remaining, ':'),'S')"/>
		<xsl:value-of select="concat($hours,$minutes,$seconds)"/>
	</xsl:template>

	<xsl:template name="durationInSecs">
		<xsl:param name="duration" />

	    <xsl:variable name="hours">
	      <xsl:value-of select="substring($duration,1,2)" />
    	</xsl:variable>
	    <xsl:variable name="minutes">
	      <xsl:value-of select="substring($duration,4,2)" />
    	</xsl:variable>
	    <xsl:variable name="seconds">
	      <xsl:value-of select="substring($duration,7,2)" />
    	</xsl:variable>
    	
    	<xsl:value-of select="(number($hours) * 60 * 60) + (number($minutes) * 60) + number($seconds)"/>
    	
	</xsl:template>
	
	<xsl:template name="tcDurationInSecs">
		<xsl:param name="timeCode" />
		<xsl:param name="frameRate" />
		
		<xsl:variable name="fps">
			<xsl:choose>
                <xsl:when test="$frameRate != ''">
                    <xsl:value-of select="$frameRate"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="24"/>
                </xsl:otherwise>
            </xsl:choose>
		</xsl:variable>
	    <xsl:variable name="hours">
	      <xsl:value-of select="substring($timeCode,1,2)" />
    	</xsl:variable>
	    <xsl:variable name="minutes">
	      <xsl:value-of select="substring($timeCode,4,2)" />
    	</xsl:variable>
	    <xsl:variable name="seconds">
	      <xsl:value-of select="substring($timeCode,7,2)" />
    	</xsl:variable>
	    <xsl:variable name="ff">
	      <xsl:value-of select="substring($timeCode,10,2)" />
    	</xsl:variable>

	    <xsl:variable name="tcInSeconds">
   	        <xsl:value-of select="(number($hours) * 60 * 60) + (number($minutes) * 60) + number($seconds) + (number($ff) div number($fps))"/>    	
    	</xsl:variable>
    	    	
    	<xsl:value-of select="format-number($tcInSeconds,'#.###')"/>    	
	</xsl:template>
	
	<xsl:template name="toSMPTE">
		<xsl:param name="timeCode" />
		<xsl:param name="frameRate" />
					
		<xsl:choose>
			<xsl:when test="not($timeCode castable as xs:decimal)">
     			<xsl:value-of select="$timeCode"/>
      		</xsl:when>
			<xsl:otherwise>				
				<xsl:variable name="fps">
					<xsl:choose>
                		<xsl:when test="$frameRate != ''">
                    		<xsl:value-of select="$frameRate"/>
                		</xsl:when>
                		<xsl:otherwise>
                    		<xsl:value-of select="24"/>
                		</xsl:otherwise>
            		</xsl:choose>
				</xsl:variable>
		
				<xsl:variable name="remainingFrames" select="$timeCode * $fps "/>		
     			<!-- Calculate new component values -->
      			<xsl:variable name="hours" select="$remainingFrames idiv (60 * 60 * $fps)"/>
      			<xsl:variable name="remainingFrames" select="$remainingFrames mod (60 * 60 * $fps)"/>
      			<xsl:variable name="minutes" select="$remainingFrames idiv (60 * $fps)"/>
      			<xsl:variable name="remainingFrames" select="$remainingFrames mod (60 * $fps)"/>
      			<xsl:variable name="seconds" select="$remainingFrames idiv $fps"/>
      			<xsl:variable name="frames" select="round($remainingFrames mod $fps)"/>

				<xsl:call-template name="padWithZero">
				     <xsl:with-param name="tcComponent" select="$hours" />
				</xsl:call-template>
      			<xsl:text>:</xsl:text>
				<xsl:call-template name="padWithZero">
				     <xsl:with-param name="tcComponent" select="$minutes" />
				</xsl:call-template>
      			<xsl:text>:</xsl:text>
				<xsl:call-template name="padWithZero">
				     <xsl:with-param name="tcComponent" select="$seconds" />
				</xsl:call-template>
      			<xsl:text>:</xsl:text>
				<xsl:call-template name="padWithZero">
				     <xsl:with-param name="tcComponent" select="$frames" />
				</xsl:call-template>
      		
      		</xsl:otherwise>
       </xsl:choose>
       
	</xsl:template>

	<xsl:template name="padWithZero">
		<xsl:param name="tcComponent" />
		<xsl:choose>
             <xsl:when test="$tcComponent > 9">
                    <xsl:value-of select="$tcComponent"/>
              </xsl:when>
              <xsl:otherwise>
      			    <xsl:text>0</xsl:text>
                    <xsl:value-of select="$tcComponent"/>
              </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="Fields/CustomFields/CustomField">
		<xsl:variable name="app" select="$Title/Fields/ProductInfo/Name"/>
		<xsl:variable name="name" select="@name"/>
		<xsl:variable name="value">
			<xsl:choose>
				<xsl:when test="BooleanValue">
					<xsl:value-of select="BooleanValue"/>
				</xsl:when>
				<xsl:when test="Value">
					<xsl:value-of select="Value"/>
				</xsl:when>
				<xsl:when test="DatetimeValue">
					<xsl:value-of select="DatetimeValue"/>
				</xsl:when>
				<xsl:when test="IntegerValue">
					<xsl:value-of select="IntegerValue"/>
				</xsl:when>
				<xsl:when test="TimeValue">
					<xsl:value-of select="TimeValue"/>
				</xsl:when>
				<xsl:when test="FloatValue">
					<xsl:value-of select="FloatValue"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:call-template name="customField">
			<xsl:with-param name="app" select="$app" />
			<xsl:with-param name="name" select="@name" />
			<xsl:with-param name="value" select="$value" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="customField">
		<xsl:param name="app"/>
		<xsl:param name="name"/>
		<xsl:param name="value"/>
			<xsl:if test="$value != ''">
				<xsl:choose>
					<xsl:when test="$name='NativeId'">
						<Mediaroom>
							<xsl:element name="{$name}">
								<xsl:value-of select="$value"/>
							</xsl:element>
						</Mediaroom>
					</xsl:when>
					<xsl:when test="$name='NativeId_PARAM_id'">
						<Mediaroom>
							<xsl:element name="{substring-before($name, '_PARAM_')}">
								<xsl:value-of select="$value"/>
							</xsl:element>
						</Mediaroom>
					</xsl:when>
					<xsl:otherwise>
						<App_Data>
							<xsl:attribute name="App"><xsl:value-of select="$app"/></xsl:attribute>
							<xsl:attribute name="Name"><xsl:value-of select="$name"/></xsl:attribute>
							<xsl:attribute name="Value"><xsl:value-of select="$value"/></xsl:attribute>
						</App_Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
	</xsl:template>
	
	<xsl:template name="ancestorAssetType">
		<xsl:param name="assetId"/>
		<xsl:for-each select="/ECMFSpec/Package/Movie | /ECMFSpec/Package/Preview | /ECMFSpec/Package/Encrypted">
			<xsl:if test="Fields/Identifier/Id = $assetId">
				<xsl:choose>
					<xsl:when test="Fields/Derived/SourceAssetId">
						<xsl:variable name="aat">
							<xsl:call-template name="ancestorAssetType">
								<xsl:with-param name="assetId" select="Fields/Derived/SourceAssetId" />
							</xsl:call-template>
			        	</xsl:variable>
			        	<xsl:choose>
			        		<xsl:when test="$aat != ''">
			        			<xsl:value-of select="$aat" />
			        		</xsl:when>
			        		<xsl:otherwise>
			        			<xsl:value-of select="Fields/CustomFields/CustomField[@name='ParentAssetType']/Value" />
			        		</xsl:otherwise>
			        	</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Fields/AssetClass"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="encodeCategoryUri">
		<!-- uriId should follow the URI Style. so after encoded, some special characters should like '/' ==> '%2F', '%2F' ==> '%252F' .
		As '/' and '%2F' has special function for category in CL format, then it should replace back '%2F' ==> '/', '%252F' ==> '%2F' after encoded -->
		<xsl:attribute name="uriId">
			<!-- <xsl:value-of select="concat( $PackageProviderId, '/Category/', Text)"/> -->
			<xsl:value-of select="concat( encode-for-uri($PackageProviderId), '/Category/', replace( replace(encode-for-uri(Text), '%2F', '/'), '%252F', '%2F' ) )"/>
		</xsl:attribute>
	</xsl:template>
	
	<xsl:template name="encodeUri">
		<!-- uriId should follow the URI Style. so after encoded, some special characters should like '/' ==> '%2F', '%2F' ==> '%252F' -->
		<xsl:param name="providerId"/>
		<xsl:param name="assetType"/>
		<xsl:param name="fieldId"/>
		<xsl:attribute name="uriId">
			<xsl:value-of select="concat( encode-for-uri($providerId), $assetType, $fieldId )"/>
		</xsl:attribute>
	</xsl:template>
</xsl:stylesheet>
