<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">

	<xsl:import href="from/common.xsl"/>
	
	<xsl:template match="/ECMFSpec/Package">
		<Offer>
			<!-- <xsl:attribute name="uriId"><xsl:value-of select="concat( $PackageProviderId, '/Offer/', $PackageAssetId )"/></xsl:attribute> -->
			<xsl:call-template name="encodeUri">
				<xsl:with-param name="providerId" select="$PackageProviderId" />
				<xsl:with-param name="assetType" select="'/Offer/'" />
				<xsl:with-param name="fieldId" select="$PackageAssetId" />
			</xsl:call-template>
			<xsl:call-template name="AMS_1" />
			<xsl:call-template name="AMS_2" />
			
			<core:Ext>
				<xsl:apply-templates select="Fields/CustomFields/CustomField" />
			</core:Ext>
			
			<!-- translate from Temporiry Category group of package
		   /Fields[1]/CategoriesTmp[1]/Category[pos1]/Text[pos2] -->
			<xsl:for-each select="$Package/Fields/CategoriesTmp/Category">
				<xsl:if test="Text">
					<offer:Presentation>
							<offer:CategoryRef>
								<xsl:call-template name="encodeCategoryUri" />
							</offer:CategoryRef>
						<xsl:if test="$Title/Fields/Rights/NewReleaseWindow">
							<offer:DisplayAsNew>
								<xsl:value-of select="concat('P',$Title/Fields/Rights/NewReleaseWindow,'D')"/>
							</offer:DisplayAsNew>
						</xsl:if>
						<xsl:if test="$Title/Fields/Rights/DisplayAsLastChance">
							<offer:DisplayAsLastChance>
								<xsl:value-of select="concat('P',$Title/Fields/Rights/DisplayAsLastChance,'D')"/>
							</offer:DisplayAsLastChance>
						</xsl:if>
					</offer:Presentation>
				</xsl:if>
			</xsl:for-each>
			
			<xsl:for-each select="$Display/Fields/Categories/Category">
				<offer:Presentation>
					<xsl:if test="Text">
						<offer:CategoryRef>
							<xsl:call-template name="encodeCategoryUri" />
						</offer:CategoryRef>
					</xsl:if>
					<xsl:if test="$Display/Fields/Rights/NewReleaseWindow">
						<offer:DisplayAsNew>
							<xsl:value-of select="concat('P',$Display/Fields/Rights/NewReleaseWindow,'D')"/>
						</offer:DisplayAsNew>
					</xsl:if>
					<xsl:if test="$Display/Fields/Rights/DisplayAsLastChance">
						<offer:DisplayAsLastChance>
							<xsl:value-of select="concat('P',$Display/Fields/Rights/DisplayAsLastChance,'D')"/>
						</offer:DisplayAsLastChance>
					</xsl:if>
				</offer:Presentation>
			</xsl:for-each>

			<offer:PromotionalContentGroupRef uriId="{$ContentGroupUriId}"/>

			<xsl:for-each select="$Package/Fields/ProviderContentTiers/ProviderContentTier">
				<offer:ProviderContentTier>
					<xsl:value-of select="Value"/>
				</offer:ProviderContentTier>
			</xsl:for-each>
			
			<xsl:if test="$Package/Fields/MetadataSpecVersion">
				<offer:SourceMetadataSpecVersion deprecated="true">
					<xsl:value-of select="$Package/Fields/MetadataSpecVersion"/>
				</offer:SourceMetadataSpecVersion>
			</xsl:if>

 			<offer:BillingId>
				<xsl:choose>
					<xsl:when test="$Title/Fields/BillingInfo/Identifier/Id">
						<xsl:value-of select="$Title/Fields/BillingInfo/Identifier/Id"/>
					</xsl:when>
					<xsl:otherwise>00000</xsl:otherwise>
				</xsl:choose>
			</offer:BillingId>
			
			<offer:TermsRef uriId="{$TermsUriId}"/>

			<!-- Check for referenced titles -->	
			<xsl:choose>
 				<xsl:when test="$Title/Fields/CustomFields/CustomField[@name='Is_PlayList']/BooleanValue = 'true'">
						<offer:ContentGroupRef>
							<xsl:call-template name="encodeUri">
								<xsl:with-param name="providerId" select="$TitleProviderId" />
								<xsl:with-param name="assetType" select="'/ContentGroup/'" />
								<xsl:with-param name="fieldId" select="$TitleAssetId" />
							</xsl:call-template>
						</offer:ContentGroupRef>		
				</xsl:when> 
				<xsl:otherwise>
					<!-- Check for referenced titles -->	
					<xsl:choose>
			   <xsl:when test="Fields/TitleGroup">
    		        <xsl:for-each select="Fields/TitleGroup">
	        		<xsl:variable name="RefTitleProviderId" select="ProviderInfo/Identifier/Id"/>
	        		<xsl:variable name="RefTitleAssetId" select="Identifier/Id"/>
		    		<xsl:if test="($RefTitleProviderId != '') and ($RefTitleAssetId != '')">		    	
		    			<offer:ContentGroupRef>
							<xsl:call-template name="encodeUri">
								<xsl:with-param name="providerId" select="$RefTitleProviderId" />
								<xsl:with-param name="assetType" select="'/ContentGroup/'" />
								<xsl:with-param name="fieldId" select="$RefTitleAssetId" />
							</xsl:call-template>
						</offer:ContentGroupRef>
					</xsl:if>
    				</xsl:for-each>
    		   </xsl:when>
    		   <xsl:otherwise>
		    		<offer:ContentGroupRef>
					    <xsl:call-template name="encodeUri">
						    <xsl:with-param name="providerId" select="$TitleProviderId" />
						    <xsl:with-param name="assetType" select="'/ContentGroup/'" />
						    <xsl:with-param name="fieldId" select="$TitleAssetId" />
					    </xsl:call-template>
				    </offer:ContentGroupRef>
    		   </xsl:otherwise>
			</xsl:choose>
				 </xsl:otherwise>
			</xsl:choose>
		</Offer>
		
		<!-- <xsl:if test="$Title/Fields/CustomFields/CustomField[@name='Is_PlayList']/BooleanValue = 'true'">
			<xsl:if test="(($Package/Fields/TitleGroup/ProviderInfo/Identifier/Id != '') and ($Package/Fields/TitleGroup/Identifier/Id != '')) or $Title/Fields/CustomFields/CustomField[@name='Ever_Playlist_Distributed']/BooleanValue = 'true'">
				<xsl:call-template name="SegmentGroup" />
			</xsl:if>
		</xsl:if> -->
	</xsl:template>

	<!-- Templates to convert trial use fields -->
	<xsl:template match="Fields/CustomFields/CustomField">
		<xsl:call-template name="customField">
			<xsl:with-param name="app" select="$Title/Fields/ProductInfo/Name" />
			<xsl:with-param name="name" select="@name" />
			<xsl:with-param name="value" select="Value" />
		</xsl:call-template>
	</xsl:template>

</xsl:stylesheet>
