<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	version="2.0">
	
	<xsl:import href="from/common.xsl"/>
		
	<xsl:template name="StillImage">
		<xsl:param name="Asset" />

		<xsl:call-template name="encodeUri">
			<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
			<xsl:with-param name="assetType" select="'/Asset/'" />
			<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
		</xsl:call-template>

		<xsl:call-template name="AMS_1" />
		<xsl:call-template name="AMS_2" />

		<xsl:if test="Fields/Derived/SourceAssetId != '' and Fields/Derived/SourceProviderId != ''">
			<core:MasterSourceRef>
				<xsl:call-template name="encodeUri">
					<xsl:with-param name="providerId" select="Fields/Derived/SourceAssetId" />
					<xsl:with-param name="assetType" select="'/Asset/'" />
					<xsl:with-param name="fieldId" select="Fields/Derived/SourceProviderId" />
				</xsl:call-template>
			</core:MasterSourceRef>
		</xsl:if>	
		
		<core:Ext>
			<xsl:apply-templates select="Fields/CustomFields/CustomField" />
		</core:Ext>
		
		<xsl:if test="Fields/Content/Locator/Uri !=''">
			<content:SourceUrl>
				<xsl:choose>
					<xsl:when test="Fields/CustomFields/CustomField[@name='PlayoutURL']/Value != ''">
						<xsl:value-of select="Fields/CustomFields/CustomField[@name='PlayoutURL']/Value"/>
					</xsl:when>		
					<xsl:otherwise>
<!--						<xsl:value-of select="Fields/Content/Locator/Uri"/>				-->
<xsl:analyze-string select="fn:translate(Fields/Content/Locator/Uri, '/', '\')" regex=".*\\([^\\]+$)">
								<xsl:matching-substring>
									<xsl:value-of select="regex-group(1)"/>
								</xsl:matching-substring>
								<xsl:non-matching-substring>
								    <xsl:value-of select="."/>
								</xsl:non-matching-substring>
						</xsl:analyze-string>
					</xsl:otherwise>
				</xsl:choose>
			</content:SourceUrl>
		</xsl:if>
		<xsl:if test="Fields/Content/Size/length">
			<content:ContentFileSize>
				<xsl:value-of select="Fields/Content/Size/length"/>
			</content:ContentFileSize>
		</xsl:if>
		<xsl:if test="Fields/Content/Checksum">
			<content:ContentCheckSum>
				<xsl:value-of select="Fields/Content/Checksum"/>
			</content:ContentCheckSum>
		</xsl:if>
		<xsl:if test="$Title/Fields/PropagationPriority" >
			<content:PropagationPriority>
				<!-- grab any one (max??) -->
				<xsl:value-of select="$Title/Fields/PropagationPriority"/>
			</content:PropagationPriority>
		</xsl:if>
		<xsl:if test="Fields/Content/Locator/Path !='' ">
			<content:ContentRef>
				<xsl:value-of select="Fields/Content/Locator/Path"/>
			</content:ContentRef>
		</xsl:if>
		<xsl:if test="Fields/Content/MIMEType">
			<content:MediaType>
				<xsl:value-of select="Fields/Content/MIMEType"/>
			</content:MediaType>
		</xsl:if>
		
		
		<xsl:variable name="ImageAspect" select="Fields/Image/AspectRatio"/>
		<xsl:if test="contains($ImageAspect, 'x')">
			<xsl:variable name="x" select="substring-before($ImageAspect, 'x')"/>
			<xsl:variable name="y" select="substring-after($ImageAspect, 'x')"/>
			<xsl:if test="$x">
				<content:X_Resolution>
					<xsl:value-of select="$x"/>
				</content:X_Resolution>
			</xsl:if>
			<xsl:if test="$y">
				<content:Y_Resolution>
					<xsl:value-of select="$y"/>
				</content:Y_Resolution>
			</xsl:if>
		</xsl:if>

		<xsl:if test="contains($ImageAspect, 'X')">
			<xsl:variable name="x" select="substring-before($ImageAspect, 'X')"/>
			<xsl:variable name="y" select="substring-after($ImageAspect, 'X')"/>
			<xsl:if test="$x">
				<content:X_Resolution>
					<xsl:value-of select="$x"/>
				</content:X_Resolution>
			</xsl:if>
			<xsl:if test="$y">
				<content:Y_Resolution>
					<xsl:value-of select="$y"/>
				</content:Y_Resolution>
			</xsl:if>
		</xsl:if>

		<xsl:for-each select="Fields/Languages/Language">
			<content:Language>
				<xsl:value-of select="@value"/>
			</content:Language>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
