#!/bin/sh

PREFERENCES_PATH="/opt/tandbergtv/cms/workflow/preferences"

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
purgeConfigProfile="${PREFERENCES_PATH}/purge-config.xml"
mkpPackagingProfile="/opt/tandbergtv/cms/workflow/preferences/profiles/mkp-packaging-profile.xml"

mkpPurgeEntry='<entry key="purge.strategy.mkp">MKP Purge Template</entry>'
if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${purgeConfigProfile} ]; then
  echo "Upgrading $purgeConfigProfile"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${purgeConfigProfile} -k /properties -v "$mkpPurgeEntry"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${mkpPackagingProfile} ]; then
  echo "Upgrading $mkpPackagingProfile"

  if egrep '<!DOCTYPE properties SYSTEM' "${mkpPackagingProfile}" >/dev/null 2>&1; then
    sed -i '/!DOCTYPE properties SYSTEM/d' ${mkpPackagingProfile}
  else
    echo \"mkp-packaging-profile\" profile has been updated.
  fi
fi