#!/bin/sh

PREFERENCES_PATH="/opt/tandbergtv/cms/workflow/preferences"

transcodeProfile="${PREFERENCES_PATH}/transcode.xml"

envivioMbrSdOutputPrefix='<entry key="ENVIVIO_MBR_SD.output.prefix"></entry>'
if [ -f ${transcodeProfile} ]; then
  echo "Upgrading $transcodeProfile"

  if egrep '<entry\s+key="ENVIVIO_MBR_SD.output.prefix">' "${transcodeProfile}" >/dev/null 2>&1; then
    echo \"ENVIVIO_MBR_SD.output.prefix\" entry already exists.
  else
    sed -i "/<entry key=\"ENVIVIO_MBR_SD.template\">/a \ \ \ \ \ \ \ \ ${envivioMbrSdOutputPrefix}" ${transcodeProfile}
    echo "$transcodeProfile upgraded successfully."
  fi
fi
