<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1"
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">

	<xsl:import href="from/audiovideo.xsl"/>
	<xsl:import href="from/common.xsl"/>
		
	<xsl:template match="/ECMFSpec/Package/Movie">
		<Asset xsi:type="content:MovieType">
			<xsl:call-template name="AudioVideo" ><xsl:with-param name="previewOrTitle" select="$Title"/></xsl:call-template>
			<xsl:for-each select="$Trick">
				<content:TrickRef>
					<xsl:call-template name="encodeUri">
						<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
						<xsl:with-param name="assetType" select="'/Asset/'" />
						<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
					</xsl:call-template>
				</content:TrickRef>
			</xsl:for-each>
		</Asset>
	</xsl:template>
	
	<xsl:template match="/ECMFSpec/Package/Encrypted">
		<xsl:variable name="ancestorAssetType">
			<xsl:call-template name="ancestorAssetType" >
				<xsl:with-param name="assetId" select="Fields/Identifier/Id"/>
			</xsl:call-template>
		</xsl:variable>	
		<xsl:choose>
			<xsl:when test="$ancestorAssetType = 'preview'">
				<Asset xsi:type="content:PreviewType">
					<xsl:call-template name="AudioVideo" >
						<xsl:with-param name="previewOrTitle" select="$Title"/>
						<xsl:with-param name="assetType" select="Fields/AssetClass"/>
					</xsl:call-template>
					<xsl:for-each select="$Trick">
						<content:TrickRef>
							<xsl:call-template name="encodeUri">
								<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
								<xsl:with-param name="assetType" select="'/Asset/'" />
								<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
							</xsl:call-template>
						</content:TrickRef>
					</xsl:for-each>
				</Asset>
			</xsl:when>
			<xsl:otherwise>
				<Asset xsi:type="content:MovieType">
					<xsl:call-template name="AudioVideo" >
						<xsl:with-param name="previewOrTitle" select="$Title"/>
						<xsl:with-param name="assetType" select="Fields/AssetClass"/>
					</xsl:call-template>
					<xsl:for-each select="$Trick">
						<content:TrickRef>
							<xsl:call-template name="encodeUri">
								<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
								<xsl:with-param name="assetType" select="'/Asset/'" />
								<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
							</xsl:call-template>
						</content:TrickRef>
					</xsl:for-each>
				</Asset>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="/ECMFSpec/Package/Preview">
		<Asset xsi:type="content:PreviewType">
			<xsl:call-template name="AudioVideo" ><xsl:with-param name="previewOrTitle" select="$Title"/></xsl:call-template>
			<xsl:for-each select="$Trick">
				<content:TrickRef>
					<xsl:call-template name="encodeUri">
						<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
						<xsl:with-param name="assetType" select="'/Asset/'" />
						<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
					</xsl:call-template>
				</content:TrickRef>
			</xsl:for-each>
		</Asset>
	</xsl:template>
	
	<xsl:template match="/ECMFSpec/Package/Barker">
		<Asset xsi:type="content:BarkerType">
			<xsl:call-template name="AudioVideo" ><xsl:with-param name="previewOrTitle" select="$Title"/></xsl:call-template>
			<xsl:for-each select="$Trick">
				<content:TrickRef>
					<xsl:call-template name="encodeUri">
						<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
						<xsl:with-param name="assetType" select="'/Asset/'" />
						<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
					</xsl:call-template>
				</content:TrickRef>
			</xsl:for-each>
		</Asset>
	</xsl:template>
	
	<xsl:template match="/ECMFSpec/Package/Trick">
		<Asset xsi:type="content:TrickType">
			<xsl:call-template name="ContentAsset"><xsl:with-param name="masterSourceRef"><xsl:value-of select="$TitleUriId"/></xsl:with-param></xsl:call-template>
			<xsl:if test="Fields/Video/BitRate">
				<content:BitRate><xsl:value-of select="Fields/Video/BitRate/@value"/></content:BitRate>
			</xsl:if>
			<xsl:if test="Fields/Vendor/Name">
				<content:VendorName>
					<xsl:value-of select="Fields/Vendor/Name"/>
				</content:VendorName>
			</xsl:if>
			<xsl:if test="Fields/Vendor/Product">
				<content:VendorProduct>
					<xsl:value-of select="Fields/Vendor/Product"/>
				</content:VendorProduct>
			</xsl:if>
			<xsl:if test="Fields/Vendor/ForVersion">
				<content:ForVersion>
					<xsl:value-of select="Fields/Vendor/ForVersion"/>
				</content:ForVersion>
			</xsl:if>
			<xsl:if test="Fields/TrickMode">
				<content:TrickMode>
					<xsl:value-of select="Fields/TrickMode"/>
				</content:TrickMode>
			</xsl:if>		
		</Asset>
	</xsl:template>

</xsl:stylesheet>