<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">
	
	<xsl:template name="contentAssetMD">
		<xsl:call-template name="AMSMD" />
		<xsl:call-template name="contentMD" />
		<xsl:call-template name="copyrightMD" />
		
		<xsl:if test="@creationDateTime">
			<CreationInfo>
					<CreateDate><xsl:value-of select="@creationDateTime"/></CreateDate>
			</CreationInfo>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="AMSMD">
		<Identifier>
			<Id><xsl:value-of select="tokenize(@uriId,'/')[last()]"/></Id>
		</Identifier>
		
		<ProviderInfo>
			<Identifier>
				<Id><xsl:value-of select="tokenize(@uriId,'/')[1]"/></Id>
			</Identifier>
			<xsl:if test="core:Provider">
				<Name><xsl:value-of select="core:Provider"/></Name>
			</xsl:if>
		</ProviderInfo>
		
		<xsl:if test="core:Product">
			<ProductInfo>
				<Name><xsl:value-of select="core:Product"/></Name>
			</ProductInfo>
		</xsl:if>
		<xsl:if test="core:AssetName">
			<AssetName><xsl:value-of select="core:AssetName"/></AssetName>
		</xsl:if>
		<xsl:if test="core:Description">
			<Description>
				<Text><xsl:value-of select="core:Description"/></Text>
			</Description>
		</xsl:if>
		
		<xsl:if test="@providerVersionNum or @internalVersionNum">
			<Version>
				<xsl:if test="@providerVersionNum">
					<Major><xsl:value-of select="@providerVersionNum"/></Major>
				</xsl:if>
				<xsl:if test="@internalVersionNum">
					<Minor><xsl:value-of select="@internalVersionNum"/></Minor>
				</xsl:if>
			</Version>
		</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="contentMD">		
		<xsl:if test="content:SourceUrl != '' or content:ContentCheckSum != '' or content:Codec != '' or content:FrameRate != '' or content:Resolution != '' or content:ContentFileSize != ''">
			<Content>
				<xsl:if test="content:SourceUrl != ''">
					<Locator>
						<Uri><xsl:value-of select="content:SourceUrl"/></Uri>
					</Locator>
				</xsl:if>
				<xsl:if test="content:ContentCheckSum != ''">
					<Checksum><xsl:value-of select="content:ContentCheckSum"/></Checksum>
				</xsl:if>
				<xsl:if test="content:Codec != ''">
					<Codec><xsl:value-of select="content:Codec"/></Codec>
				</xsl:if>
				<xsl:if test="content:FrameRate != ''">
					<FrameRate><xsl:value-of select="content:FrameRate"/></FrameRate>
				</xsl:if>
				<xsl:if test="content:Resolution != ''">
					<Resolution><xsl:value-of select="content:Resolution"/></Resolution>
				</xsl:if>
				<xsl:if test="content:ContentFileSize != ''">
					<Size>
						<length><xsl:value-of select="content:ContentFileSize"/></length>
					</Size>
				</xsl:if>
			</Content>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="copyrightMD">
		<xsl:if test="content:CopyControlInfo">
			<Copyright>
				<xsl:if test="content:CopyControlInfo/content:AnalogProtectionSystem">
					<AnalogProtectionSystem><xsl:value-of select="content:CopyControlInfo/content:AnalogProtectionSystem"/></AnalogProtectionSystem>
				</xsl:if>
				<xsl:if test="content:CopyControlInfo/content:CGMS_A">
					<CGMSA><xsl:value-of select="content:CopyControlInfo/content:CGMS_A"/></CGMSA>
				</xsl:if>
				<xsl:if test="content:CopyControlInfo/content:ConstrainedImageTrigger">
					<ConstrainedImageTrigger><xsl:value-of select="content:CopyControlInfo/content:ConstrainedImageTrigger"/></ConstrainedImageTrigger>
				</xsl:if>
				<xsl:if test="content:CopyControlInfo/content:IsCopyProtection">
					<CopyProtection><xsl:value-of select="content:CopyControlInfo/content:IsCopyProtection"/></CopyProtection>
				</xsl:if>
				<xsl:if test="content:CopyControlInfo/content:IsCopyProtectionVerbose">
					<CopyProtectionVerbose><xsl:value-of select="content:CopyControlInfo/content:IsCopyProtectionVerbose"/></CopyProtectionVerbose>
				</xsl:if>
				<xsl:if test="content:CopyControlInfo/content:EncryptionModeIndicator">
					<EncryptionModeIndicator><xsl:value-of select="content:CopyControlInfo/content:EncryptionModeIndicator"/></EncryptionModeIndicator>
				</xsl:if>
				
				<!-- comment content:RequiresOutputControl as core defines CF RequiresOutputControl, however, pp uses the CF Selectable_Output_Control for CL30 distribution
				<xsl:if test="content:CopyControlInfo/content:RequiresOutputControl">
					<CustomFields>
						<CustomField>
							<xsl:attribute name="name">Selectable_Output_Control</xsl:attribute>
							<BooleanValue><xsl:value-of select="content:CopyControlInfo/content:RequiresOutputControl"/></BooleanValue>
						</CustomField>
					</CustomFields>
				</xsl:if> -->
			</Copyright>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>