#!/usr/bin/env python
#
# Copyright (c) 2019 MediaKind, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#

from lxml import etree

class CMSLicense:
    def __init__(self, licenseFilePath="/opt/tandbergtv/cms/conf/neptune/license.xml"):
        self._licenseFilePath = licenseFilePath
        self.loadLicenseContent()
        
    def loadLicenseContent(self):
        self._tree = etree.parse(self._licenseFilePath)
        if self._tree:
            self._root = self._tree.getroot()
        
    def isCompact(self):
        isCompact = False
        for cmsCompactDescription in self._root.findall("./body/SWLT/fingerprint/featureKey[@id='FAT1024087']/description"):
            if cmsCompactDescription.text == 'CMS Compact':
                isCompact = True
        
        return isCompact
    
def main():
    cmsLicense = CMSLicense()
    if cmsLicense.isCompact():
        print 'yes'
    
if __name__ == "__main__":
    main()
    