#!/usr/bin/env python
import re
import os
import xml
from MeSubsProfile import MeSubsProfile
from RulesetsRestMgr import RulesetsRestMgr

from lxml import etree
from io import StringIO, BytesIO


class EnhancementRuleset(object):
	
 	def __init__(self):
 		pass

 	def __isMetadataEnhancementRuleset__(self, ruleSet):
		isMeRuleset = False
		
		for param in ruleSet.findall("rules/rule/actions/action/params/param"):
			nameElement = param.findall("name")
			valueElement = param.findall("value")
            		
			# verify if this a Enhancement rule
			if nameElement and valueElement	and nameElement[0].text == 'fieldType' \
					and valueElement[0].text == 'ENHANCEMENT':
				isMeRuleset = True
				break
	 	
	 	return isMeRuleset

 	def __getMetadataEnhancementRulesets__(self, filePath):
 		if not os.path.exists(filePath):
 			return []
 		
 		tree = etree.parse(filePath)
		root = tree.getroot()
		ruleSets = []
		
		for ruleSet in root.findall("ruleSets/ruleSet"):
			if self.__isMetadataEnhancementRuleset__(ruleSet):
				ruleSets.append(ruleSet)
		
		return ruleSets
		

 	def __getMetadataEnhancementRulesetsInTree__(self, tree):
		root = tree.getroot()
		ruleSets = []
		
		for ruleSet in root.findall("ruleSets/ruleSet"):
			if self.__isMetadataEnhancementRuleset__(ruleSet):
				ruleSets.append(ruleSet)
				
		return ruleSets

 	def __getUuidOfMeRulesets__(self, filePath):
 	 	"""
 	 	Description: find the uuids of the me rule set in the specified xml
 	 	
 	 	@param filePath: the rule set xml which may contains multiple rule sets
 	 	"""
 	 	meRuleSets = self.__getMetadataEnhancementRulesets__(filePath)
 	 	uuids = []
 	 	
 	 	for ruleSet in meRuleSets:
 	 		uuidElement = ruleSet.find("uuid")
 	 		if uuidElement is not None and uuidElement.text:
 	 			uuids.append(uuidElement.text)

 	 	return uuids

 	def hasMetadataEnhancementRuleset(self, filePath):
 		if not os.path.exists(filePath):
 			return False
 		
 		tree = etree.parse(filePath)
		root = tree.getroot()
		
		for ruleSet in root.findall("ruleSets/ruleSet"):
			if self.__isMetadataEnhancementRuleset__(ruleSet):
				return True

	def extractMetadataEnhancementRuleset(self, xmlPathOfRuleset, newXmlPath):
		"""
		Description: extract the ME ruleset from the xml file and save to a new file.
					
		@param xmlPathOfRuleset: the xml file which contains many rule sets
		"""
 		
		xmlTemplateString = StringIO(u'''\
<ruleSetsListing>
	<ruleSets> 
	</ruleSets>
</ruleSetsListing>''')

 		tree = etree.parse(xmlTemplateString)
         
 		meRulesets = self.__getMetadataEnhancementRulesets__(xmlPathOfRuleset)
 		
 		if len(meRulesets):
 			root = tree.getroot()
 			rulesetsElement = root.find("ruleSets")
 			
 			for ruleset in meRulesets:
 		 		rulesetsElement.append(ruleset)

 		 	tree.write(newXmlPath, xml_declaration=True, pretty_print=True, encoding="UTF-8") 	
 		  	
			return True
		
		return False
 			  	
 	def replaceWithProfileName(self, filePath):
 		"""
 		Description:
 			Replace all the profile ids in the @filePath with the actual 
 			profile name.
 		"""
 		if not os.path.exists(filePath):
 			return False
		
		tree = etree.parse(filePath)
		root = tree.getroot()
		meProfile = MeSubsProfile()
		changed = False
		
		for ruleSet in self.__getMetadataEnhancementRulesetsInTree__(tree):
			for action in ruleSet.findall("rules/rule/actions/action"):
				params = action.find("params")
				if params is not None:
					isMetaDataEnhancement = False
					for param in params.findall("param"):
						nameElement = param.findall("name")
						valueElement = param.findall("value")
							
						# verify if this a Enhancement rule
						if nameElement and valueElement	and nameElement[0].text == 'fieldType' \
							and valueElement[0].text == 'ENHANCEMENT':
							isMetaDataEnhancement = True
							
						# Get the profile Id and replace with the profile name
						if nameElement and valueElement	and nameElement[0].text == 'sectionType' \
							and isMetaDataEnhancement:
							profileId = valueElement[0].text
							profileName = meProfile.getProfileNameById(int(profileId))
							
							if profileName:
								valueElement[0].text = profileName
								changed = True
							else:
								print "[Warning]EnhancementRuleset:replaceWithProfileName: unknown profile Id " + profileId
						
		if changed:
			tree.write(filePath, xml_declaration=True, encoding="UTF-8")
			
	def replaceWithProfileId(self, filePath):
 		"""
 		Description:
 			Replace all the profile names in the @filePath with the actual 
 			profile id.
 		"""
 		if not os.path.exists(filePath):
 			return False
 		
 		tree = etree.parse(filePath)
		root = tree.getroot()
		meProfile = MeSubsProfile()
		changed = False
		
		for ruleSet in self.__getMetadataEnhancementRulesetsInTree__(tree):
			for action in ruleSet.findall("rules/rule/actions/action"):
				params = action.find("params")
				if params is not None:		
					isMetaDataEnhancement = False
					for param in params.findall("param"):
						nameElement = param.findall("name")
						valueElement = param.findall("value")
							
						# verify if this a Enhancement rule
						if nameElement and valueElement	and nameElement[0].text == 'fieldType' \
							and valueElement[0].text == 'ENHANCEMENT':
							isMetaDataEnhancement = True
							
						# Get the profile Id and replace with the profile name
						if nameElement and valueElement	and nameElement[0].text == 'sectionType' \
							and isMetaDataEnhancement:
							profileName = valueElement[0].text
							profileId = meProfile.getProfileIdByName(profileName)
							
							if profileId:
								valueElement[0].text = str(profileId)
								changed = True
							else:
								print"[Warning]EnhancementRuleset:replaceWithProfileId: unknown profile name " + profileName
						
		if changed:
			tree.write(filePath, xml_declaration=True ,encoding="UTF-8")
 		
def main():
	enhance = EnhancementRuleset()
	
	filePath = "C:\\testpython\\testfile\\original\\TestMEEnhanceRule.xml"
	
	print enhance.hasMetadataEnhancementRuleset(filePath)
	if enhance.hasMetadataEnhancementRuleset(filePath):
             enhance.replaceWithProfileId(filePath)
               
	print enhance.__getUuidOfMeRulesets__("C:\\testpython\\testfile\\RuleSetsME_EnhanceUniversalAssetMetadata.xml")
	enhance.extractMetadataEnhancementRuleset("C:\\testpython\\testfile\\RuleSetsME_EnhanceUniversalAssetMetadata.xml", "C:\\testpython\\output\\output_RuleSetsME_EnhanceUniversalAssetMetadata.xml")
	enhance.extractMetadataEnhancementRuleset("C:\\testpython\\testfile\\original\\test.xml", "C:\\testpython\\testfile\\original\\extract-testfile1.xml")
if __name__ == "__main__":
	main()
