#!/usr/bin/env python
import re
import sys
import BaseClass
import base64
from K8sUtil import *
from KubernetesConstants import *

FTP_CONFIG_KEY = "ftp.properties"


class FTPConfiguration(BaseClass.BaseHandler):

    def __init__(self):
        BaseClass.BaseHandler.__init__(self)
        self.ftp_content = ""
        self.initFTPContent()

    def checkExistence(self, data):
        if len(self.ftp_content) == 0:
            return False
        hostRegex = r'(^|\s*)%s\s'
        return re.search(hostRegex % (data[0]), self.ftp_content) is not None

    def getNextId(self):
        return 0

    def insert(self, id_, data):
        try:
            print "[INFO] Adding ftp configuration '%s' to in the secrets of '%s'..." % (data[0], EXTERNAL_CREDENTAIL_SECRET)
            self.ftp_content = self.ftp_content + "\n%s\t%s\t%s" % (data[0], data[1], data[2])
            return K8sUtil.patch(SECRET, EXTERNAL_CREDENTAIL_SECRET, FTP_CONFIG_KEY,
                                 base64.b64encode(self.ftp_content))
        except Exception:
            raise

    def initFTPContent(self):
        success, data = K8sUtil.getData(SECRET, EXTERNAL_CREDENTAIL_SECRET, FTP_CONFIG_KEY)
        if not success:
            print "[ERROR] Fetching existing secret key from %s failure, exit installation" % EXTERNAL_CREDENTAIL_SECRET
            sys.exit(1)
        if len(data) > 0:
            self.ftp_content = base64.b64decode(data)