#!/usr/bin/env python

# Author: Gavin Zhong
# Created: Nov 4, 2020
# Description:
# Helper Class in geo installation
import os
from KubernetesConstants import *
import json
from K8sUtil import *

class InstallGeoHelper(object):
    CMS_GEO_EXCLUDE_PROFILE = "custom_geo_rsyncexcludes.txt"
    CMS_GEO_EXCLUDE_CONFIG_MAP = "cms-geo-filersync-client-config"
    GEO_RSYNC_EXCLUDE_PATHS = ["/opt/tandbergtv/cms/conf/prepack"]

    @staticmethod
    def isDefaultOrGeoPrimary(config):
        if 'geoDomain' in config:
            return config['geoDomain'] == "Primary"
        return InstallGeoHelper.getGeoRole() == "Primary"

    @staticmethod
    def isGeoSecondary(config):
        if 'geoDomain' in config:
            return config["geoDomain"] == "Secondary"
        return InstallGeoHelper.getGeoRole() == "Secondary"

    @staticmethod
    def getGeoRole():
        if not InstallGeoHelper.isGeoEnabled():
            return "Primary"

        # Get geo role from config map
        GEO_ROLE_COMMAND = "kubectl get cm cms-geo-configmap -n "+ CMS_NAMESPACE + " -o yaml | grep 'geoRole' | sed -n '1p' | awk -F ':' '{print $2}'"
        geoRole = os.popen(GEO_ROLE_COMMAND, "r").read().strip()
        if len(geoRole) == 0:
            print("[ERROR] The GEO Role(Primary/Secondary) is necessary when the GEO setup is enabled.")
            return None
        return geoRole

    @staticmethod
    def autoDetectGeoDomain(config,userSpecifiedGeoDomain):
        if userSpecifiedGeoDomain is not None:
            config['geoDomain'] = userSpecifiedGeoDomain
            return

    @staticmethod
    def isGeoEnabled():
        # Check if the geo is enabled in current Container env.
        GEO_ENABLED_COMMAND="kubectl get cm cms-geo-setup-status-configmap -n " + CMS_NAMESPACE + " -o yaml | grep 'geoEnabled' | sed -n '1p' | awk -F ':' '{print $2}'"
        geoEnabled = os.popen(GEO_ENABLED_COMMAND, "r").read().strip()

        if len(geoEnabled) == 0 or geoEnabled == '""' or geoEnabled == '"N"':
            return False
        return True

    @staticmethod
    def deleteExtraSpaceAndFilterEmpty(georsync_excludes_array):
        while '' in georsync_excludes_array:
            georsync_excludes_array.remove('')
        for i in range(len(georsync_excludes_array)):
            georsync_excludes_array[i] = georsync_excludes_array[i].strip()

    @staticmethod
    def excludeFoldersFromGeoSync():
        #custom_geo_rsyncexcludes.txt: |-
        #    /opt/tandbergtv/cms/conf/prepack
        #    /opt/tandbergtv/cms/conf/prepack1
        GET_CMS_GEO_EXCLUDE_CONFIG_MAP="kubectl get cm " + InstallGeoHelper.CMS_GEO_EXCLUDE_CONFIG_MAP + " -n mkcms -o json"
        geoExcludeConfigStr = os.popen(GET_CMS_GEO_EXCLUDE_CONFIG_MAP, "r").read().strip()
        if len(geoExcludeConfigStr) == 0:
            print("[ERROR] The configmap " + InstallGeoHelper.CMS_GEO_EXCLUDE_CONFIG_MAP +" doesn't exist")
            return

        geoExcludeConfig = json.loads(geoExcludeConfigStr)
        geoExcludeFiles = geoExcludeConfig["data"]["custom_geo_rsyncexcludes.txt"]
        georsync_excludes_array = geoExcludeFiles.split('\n')
        InstallGeoHelper.deleteExtraSpaceAndFilterEmpty(georsync_excludes_array)

        modified = False
        for excludePath in InstallGeoHelper.GEO_RSYNC_EXCLUDE_PATHS:
            if excludePath not in georsync_excludes_array:
                modified = True
                georsync_excludes_array.append(excludePath)

        if modified:
            georsync_excludes = '\n'.join(georsync_excludes_array)
            K8sUtil.patch(CONFIGMAP, InstallGeoHelper.CMS_GEO_EXCLUDE_CONFIG_MAP, InstallGeoHelper.CMS_GEO_EXCLUDE_PROFILE, georsync_excludes)