#!/usr/bin/env python
import BaseClass
import MeSubsProfile
from MeFieldDefinition import MeEnhanceFieldDefinition,MeFieldDefinition 

class MeEnhancedField(BaseClass.BaseClass):
	"""
		data[0]: NAME			LWS
		data[1]: meProfileName	SD
		data[2]: MAPPING		TITLE
		data[3]: DATATYPE		date
		data[4]: PATH			/Fields/Rights/LicensingWindowStart
	"""
	
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
	
	def checkExistence(self, data):		
		"""
		data[0]: fieldName
		data[1]: ME profile Name
		"""		
		fieldName 		= data[0]
		meProfileName	= data[1]
		
		meProfileId 	= self.getMeProfileId(meProfileName)
		if meProfileId == False:
			return False
		
		statement = "select EF.ID from ME_ENHANCED_FIELD EF " \
					"join ME_FIELD_DEFINITION FD on (FD.ID = EF.FIELD_ID)" \
					"where FD.NAME = '%s' and EF.PROFILE_ID = '%s'" % (fieldName, meProfileId)
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False		

	def getNextId(self):
		return 1

	def backUpExisting(self, data):
		"""
		data[0]: Field Name
		data[1]: ME Profile Name
		
		return an array contains (NAME,MAPPING,DATATYPE,PATH) of the given profile name specified by data[0:1]
		
		"""
		if len(data) >= 2:
			fieldName = data[0]
			meProfileName = data[1]
		
			fieldId = self.getFieldId(fieldName, meProfileName)
			
			if fieldId == False:
				return []
			
			return  MeFieldDefinition().getFields(fieldId)
		else:
			print("MeEnhancedField::backUpExisting:The number of parameters is not correct")
			return []
					
	def backUpAllExisting(self, profileName):
		"""
		backup all the enhance fields of a given profile
		"""
		profileId = self.getMeProfileId(profileName)
		
		if profileId == False:
			print "[Error]MeEnhancedField::backUpAllExisting: profile %s not found!" % profileName
			return []
		
		enhanceFieldKeyArray = ["NAME", "MAPPING", "DATATYPE", "PATH"]
		statement = "SELECT FD.NAME, FD.MAPPING, FD.DATATYPE, FD.PATH FROM ME_FIELD_DEFINITION FD" \
					" JOIN ME_ENHANCED_FIELD EF ON (FD.ID = EF.FIELD_ID)" \
					" WHERE EF.PROFILE_ID = %d" % profileId
		self.cursor.execute(statement)
		
		rows = self.cursor.fetchall()
		if len(rows):
			enhanceFields = []
			for row in rows:
				enhanceField = {}
				for i in range(0, len(enhanceFieldKeyArray)):
					if row[i] == None:
						enhanceField[enhanceFieldKeyArray[i]] = ""
					else:
						enhanceField[enhanceFieldKeyArray[i]] = row[i]
				enhanceFields.append(enhanceField)
		return enhanceFields
		
	def insert(self, id_, data):
		try:
			fieldName 			= data[0]
			meProfileName		= data[1]
			mapping				= data[2]
			datatype			= data[3]
			path				= data[4]
			
			meProfileId 	= self.getMeProfileId(meProfileName)
			if meProfileId == False:
				return False
			
			fieldId = self.insertFieldDefinition(data)
			if fieldId == False:
				return False			
			
			statement = "INSERT INTO ME_ENHANCED_FIELD (PROFILE_ID, FIELD_ID) VALUES %s" % self.tupleToStr([meProfileId, fieldId])
			print statement 
			self.cursor.execute(statement)	
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
		
	def update(self, data):
		try:
			self.updateFieldDefinition(data)
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
	
	def delete(self, data):
		fieldName 		= data[0]
		meProfileName	= data[1]
		
		enhanceId = self.checkExistence(data)
		fieldId = self.getFieldId(fieldName, meProfileName)
		
		try: 
			# delete from table ME_ENHANCED_FIELD first
			if enhanceId != False:
				statement = "DELETE FROM ME_ENHANCED_FIELD WHERE ID = %d" % enhanceId
				print statement
				self.cursor.execute(statement)
			
			if fieldId != False:
				self.deleteFieldDefinition(fieldId)
			
			if enhanceId != False or fieldId != False:
				return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def deleteAll(self, profileId):
		"""
		Description: delete all the enhance field of the profile
		"""
		# delete from table ME_ENHANCED_FIELD first
		statement = "DELETE FROM ME_ENHANCED_FIELD WHERE PROFILE_ID = %d" % profileId
		print statement
		self.cursor.execute(statement)
			
				
	def insertFieldDefinition(self, data):
		fieldDefinition = MeEnhanceFieldDefinition()
		return fieldDefinition.insert(data)

	def updateFieldDefinition(self, data):
		fieldDefinition = MeEnhanceFieldDefinition()
		fieldDefinition.update(data)
		
	def deleteFieldDefinition(self, fieldId):
		fieldDefinition = MeEnhanceFieldDefinition()
		fieldDefinition.delete(fieldId)
				
	def getMeProfileId(self, *data):
		return MeSubsProfile.MeSubsProfile().checkExistence(data)
	
	def getFieldId(self, *data):
		return MeEnhanceFieldDefinition().getId(data)
	
	def getIsDelete(self, item):
		if not item.has_key("IS_DELETE"):
			return False
		else:
			return item["IS_DELETE"].lower() == "true"

def main():
	meEnF = MeEnhancedField()
	
if __name__ == "__main__":
	main()