#!/usr/bin/env python
import BaseClass
import os
import xml
import re
import sys

from xml.dom.minidom import parseString
from xml.sax.saxutils import unescape

class WatchFolderConfiguration(BaseClass.BaseHandler):
    filePath = "/opt/tandbergtv/cms/conf/watchfolder/watchfolder.xml"
    tempFilePath = "./watchfolder.xml"

    def __init__(self):
        BaseClass.BaseHandler.__init__(self)
    
    def checkExistence(self, data):
        if not self.checkFileExistence():
            return False
        
        try:
            with open(self.filePath, "r") as f:
                file_content = f.read()
            try:
                dom = parseString(file_content)
            except  xml.parsers.expat.ExpatError as err:
                return False
            
            item = filter(lambda element : element.getAttribute("path") == data[0] and self.trim(element.getElementsByTagName("filter")[0].firstChild.nodeValue) == data[1], dom.getElementsByTagName("directory"))
            try:
                return item[0]
            except:
                return False

        except Exception:
            raise

    def getNextId(self):
        return 0

    def prettyxml(self, dom):
        prettyxml = dom.toprettyxml()
        prettyxml = os.linesep.join([s for s in prettyxml.splitlines() if s.strip()])
        prettyxml = re.sub(r'>\n\t*([^<]+)\n\t*<', r'>\1<', prettyxml)
        prettyxml = re.sub(r'<filter>\n\t*(<.*>)\s*</filter>', r'<filter>\1</filter>', prettyxml)

        return prettyxml
    
    def insert(self, id_, data):
        self.initFileIfNotExists()
        print "Adding watch folder configuration '%s' filter '%s' to watchfolder.xml..." % (data[0], data[1])       
        try:
            with open(self.filePath, "r") as f:
                file_content = f.read()
            dom = parseString(file_content)
            self.insertDom(dom, data)

            #Enhance for azure, not permission to write the file. chmod command also invalid for CIFS mount.
            #So write to the temporary file and copy to destination by sudo.
            prettyxml = self.prettyxml(dom)
            with open(self.tempFilePath, "w") as fout:
                fout.write(unescape(prettyxml))

            copy_cmd = 'sh -c  "\cp %s $(echo $(readlink -f %s))"' % (self.tempFilePath, self.filePath)
            os.system(copy_cmd)
        except Exception:
            raise

    def checkFileExistence(self):   
        return os.path.exists(self.filePath)

    def checkAndMkdirs(self):
        subpath = self.filePath[0:self.filePath.rfind("/")]
        try:
            remote_cmd = 'sh -c  "\ls %s"' % (subpath)
            status = os.system(remote_cmd)
            
            if status != 0:
                print "creating directories:", subpath               
                mkdirs_cmd = 'sh -c  "\mkdir -p %s"' % (subpath)
                status_cmd = os.system(mkdirs_cmd)

                if status_cmd != 0:
                    sys.exit("fail to create directories %s" % subpath)
        except Exception:
            raise
                
    def initFileIfNotExists(self):
        if not self.checkFileExistence():
            self.initFile()
        else:
            file_content = None
            with open(self.filePath, "r") as f:
                file_content = f.read()
            try:
                dom = parseString(file_content)
            except  xml.parsers.expat.ExpatError as err:
                self.initFile()

    def initFile(self):
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><directories/>"
        self.checkAndMkdirs()
        try:
            # Enhance for azure, not permission to write the file. chmod command also invalid for CIFS mount.
            # So write to the temporary file and move to destination by sudo.
            new_file_cmd = 'sh -c  "\\touch %s"' % (self.tempFilePath)
            os.system(new_file_cmd)
            with open(self.tempFilePath, "w") as f:
                f.write(xml)
            cp_cmd = 'sh -c  "\cp %s $(echo $(readlink -f %s))"' % (self.tempFilePath, os.path.dirname(self.filePath))
            os.system(cp_cmd)
            
        except Exception:
            raise
        
    def insertDom(self, dom, data):          
          
        root = dom.getElementsByTagName("directories")[0]
        
        directoryElement = dom.createElement("directory")
        directoryElement.setAttribute("path", data[0])
        
        filterElement = dom.createElement("filter")
        filterElement.appendChild(dom.createTextNode(data[1]))
        directoryElement.appendChild(filterElement)
        
        frequencyElement = dom.createElement("frequency")
        frequencyElement.appendChild(dom.createTextNode(data[2]))
        directoryElement.appendChild(frequencyElement)
        
        processElement = dom.createElement("process")
        
        classElement = dom.createElement("class")
        classElement.appendChild(dom.createTextNode(data[3]))
        processElement.appendChild(classElement)
        
        parameterListElement = dom.createElement("parameterList")
        
        commandElement = dom.createElement("parameter")
        commandElement.setAttribute("name", "command")
        commandElement.setAttribute("value", "create")
        parameterListElement.appendChild(commandElement)
        
        messageuidElement = dom.createElement("parameter")
        messageuidElement.setAttribute("name", "messageUID")
        messageuidElement.setAttribute("value", data[4])
        parameterListElement.appendChild(messageuidElement)
        
        dateFormatElement = dom.createElement("parameter")
        dateFormatElement.setAttribute("name", "dateFormat")
        dateFormatElement.setAttribute("value", "yyyy-MM-dd HH:mm:ss")
        parameterListElement.appendChild(dateFormatElement)

        '''commandParameter'''
        self.insertParameters(dom, data[5], "commandParameter.", parameterListElement)

        '''messageParameter'''
        self.insertParameters(dom, data[6], "messageParameter.", parameterListElement)
            
        if data[7]:
            routingDirElement = dom.createElement("parameter")
            routingDirElement.setAttribute("name", "routingDir")
            routingDirElement.setAttribute("value", data[7])
            parameterListElement.appendChild(routingDirElement)
            
        if data[8]:
            failureDirElement = dom.createElement("parameter")
            failureDirElement.setAttribute("name", "failureDir")
            failureDirElement.setAttribute("value", data[8])
            parameterListElement.appendChild(failureDirElement)
        
        if data[9]:
            looseFileNamePatternElement = dom.createElement("parameter")
            looseFileNamePatternElement.setAttribute("name", "looseFileNamePattern")
            looseFileNamePatternElement.setAttribute("value", data[9])
            parameterListElement.appendChild(looseFileNamePatternElement)
                        
        processElement.appendChild(parameterListElement)
        
        directoryElement.appendChild(processElement)
        
        eventsElement = dom.createElement("events")
        eventsElement.appendChild(dom.createTextNode(data[10]))
        directoryElement.appendChild(eventsElement)
        
        threadsElement = dom.createElement("threads")
        threadsElement.appendChild(dom.createTextNode(data[11]))
        directoryElement.appendChild(threadsElement)
       
        root.appendChild(directoryElement)
        
    def insertParameters(self, dom, parameters, prefix, parameterListElement):
        notEmptyDit = (type(dict()) == type(parameters)) and len(parameters.keys()) != 0        
        if notEmptyDit:
            for parameter in parameters.items():
                parameterElement = dom.createElement("parameter")
                parameterElement.setAttribute("name", prefix + parameter[0]);
                parameterElement.setAttribute("value", parameter[1]);
                parameterListElement.appendChild(parameterElement)
        
    def update(self, data):
        print "Updating watch folder configuration '%s' filter '%s' to watchfolder.xml..." % (data[0], data[1])

        try:
            with open(self.filePath, "r") as f:
                file_content = f.read()
            dom = parseString(file_content)
            item = filter(lambda element : element.getAttribute("path") == data[0] and self.trim(element.getElementsByTagName("filter")[0].firstChild.nodeValue) == data[1], dom.getElementsByTagName("directory"))

            dom.getElementsByTagName("directories")[0].removeChild(item[0])
            self.insertDom(dom, data)

            #Enhance for azure, not permission to write the file. chmod command also invalid for CIFS mount.
            #So write to the temporary file and copy to destination by sudo.
            prettyxml = self.prettyxml(dom)
            with open(self.tempFilePath, "w") as fout:
                fout.write(unescape(prettyxml))

            copy_cmd = 'sh -c  "\cp %s $(echo $(readlink -f %s))"' % (self.tempFilePath, self.filePath)
            os.system(copy_cmd)
        except Exception:
            raise
        
    def delete(self, data):
        """ delete a watchfolder from the configuration file
        data[0]: watchfolder path
        data[1]: filter        
        """
        print "Delete watch folder configuration '%s' filter '%s' to watchfolder.xml..." % (data[0], data[1])

        try:
            with open(self.filePath, "r") as f:
                file_content = f.read()
            dom = parseString(file_content)
            item = filter(lambda element : element.getAttribute("path") == data[0] and self.trim(element.getElementsByTagName("filter")[0].firstChild.nodeValue) == data[1], dom.getElementsByTagName("directory"))

            if item is not None and len(item):
                dom.getElementsByTagName("directories")[0].removeChild(item[0])
                            
                #Enhance for azure, not permission to write the file. chmod command also invalid for CIFS mount.
                #So write to the temporary file and copy to destination by sudo.
                prettyxml = self.prettyxml(dom)
                with open(self.tempFilePath, "w") as fout:
                    fout.write(unescape(prettyxml))

                copy_cmd = 'sh -c  "\cp %s $(echo $(readlink -f %s))"' % (self.tempFilePath, self.filePath)
                os.system(copy_cmd)
                
        except Exception:
            raise
