/*
 * Data patch for filtering validation rules for Offer title
 * Purpose: All validation rule should not work for offer title.
 * Author: Jane on 7th DEC 2016
 * Modified script to plpgsql by Suresh Neravati on 08/23/2017
 */
DO $$ 
DECLARE
   recursor       cursor FOR SELECT RULESETID,RULENAME,TITLEFILTERID FROM TRE_RULESET t 
									WHERE PACKAGEID IN (SELECT PACKAGEID FROM TRE_PACKAGE WHERE NAME='VALIDATION');
   t_rulesetid    numeric(10,0);
   rulesetname    text;
   filterid       numeric(10,0);
   rec_count      numeric(10,0);
   node_count     numeric(10,0);
   t_rootnodeid   numeric(10,0);
   t_predicatedid numeric(10,0);
BEGIN
   OPEN recursor;
   LOOP
     FETCH recursor INTO t_rulesetid,rulesetname,filterid;
     EXIT WHEN NOT FOUND;
     RAISE NOTICE 'processing rule:%,rulesetid:%,filterid:%',rulesetname,t_rulesetid,filterid;
     SELECT count(*) INTO rec_count FROM TRE_TITLEFILTER WHERE TITLEFILTERID=filterid and ROOTNODEID is null;
     IF rec_count > 0  THEN
       SELECT nextval('TRE_EXPNODE_SEQ') INTO t_rootnodeid;
       INSERT INTO TRE_EXPNODE VALUES(t_rootnodeid,'List', null,'AND',null,null,now(),now());
       UPDATE TRE_TITLEFILTER SET ROOTNODEID = t_rootnodeid WHERE TITLEFILTERID = filterid;
       RAISE NOTICE 'root node id is null,after updated TRE_TITLEFILTER table,root node id is:%', t_rootnodeid;
     END IF;
     SELECT ROOTNODEID INTO t_rootnodeid FROM TRE_TITLEFILTER WHERE TITLEFILTERID=filterid;
     RAISE NOTICE 'root node id is:%', t_rootnodeid;
     SELECT count(*) INTO node_count FROM TRE_EXPNODE exp WHERE PARENTID = t_rootnodeid 
        and exists (SELECT * FROM TRE_PREDICATE pre WHERE FIELDLEFT='contentClassId' and pre.PREDICATEID = exp.PREDICATEID); 
     IF node_count=0 THEN
       SELECT nextval('TRE_PREDICATE_SEQ') INTO t_predicatedid;
       INSERT INTO TRE_PREDICATE VALUES(t_predicatedid,'V',0,'contentClassId',null,'PMM_TITLE',null,'PMM_TITLE',null,1,'EQUAL',null,null,1,now(),now());
       INSERT INTO TRE_PREDICATEVALUE VALUES(t_predicatedid,(SELECT ID FROM PMM_CONTENT_CLASS WHERE NAME='Offer'),0);
       INSERT INTO TRE_EXPNODE 
       VALUES(nextval('TRE_EXPNODE_SEQ'),'Value',t_predicatedid,null,t_rootnodeid,(SELECT count(*) FROM TRE_EXPNODE WHERE PARENTID = t_rootnodeid),now(),now());
       RAISE NOTICE 't_predicatedid:%',t_predicatedid;
       RAISE NOTICE 'process complete for rule:%', t_rulesetid;
     END IF;
   END LOOP;
   CLOSE recursor;
END;
$$ language plpgsql;
