#!/bin/sh

SUBSYSTEMS_PATH="/opt/tandbergtv/cms/plugins/workflow/plugins/subsystems"

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"

metadataUpdateConfig="${SUBSYSTEMS_PATH}/content-management-additional/resources/properties/metadata-update-config.xml"
metadataUpdateConfigForStandalone="${SUBSYSTEMS_PATH}/content-management-additional/resources/properties/metadata-update-config-for-standalone.xml"
qcProcessingProfile="/opt/tandbergtv/cms/workflow/preferences/profiles/qc.xml"

qcProfile_Ffmpeg='<profile name="ffmpeg-qc">
    <template>Ffmpeg QC</template>
    <execute-profile>show_streams</execute-profile>
    <!-- The QC result report will be save to this url with file name {assetId}_{workOrderId}.xml -->
    <!-- Change this entry to empty if do not want to save the report -->
    <report.url.prefix>https://test.blob.core.windows.net/test/{PACKAGE_PROVIDER_ID}-{PACKAGE_ASSET_ID}</report.url.prefix>
    <content.file.regex>.*\.mp4$|.*\.ts$|.*\.avi$|.*\.mov$|.*\.ogg$|.*\.wmv$|.*\.webm$</content.file.regex>
</profile>'

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${metadataUpdateConfig} ]; then
  echo Upgrading $metadataUpdateConfig
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfig} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED\" path=\"QC_Profile\" value=\"\"/>"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${metadataUpdateConfigForStandalone} ]; then
  echo Upgrading $metadataUpdateConfigForStandalone
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfigForStandalone} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED\" path=\"QC_Profile\" value=\"\"/>"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${qcProcessingProfile} ]; then
  echo "Upgrading $qcProcessingProfile"

  if egrep '<profile\s+name="ffmpeg-qc">' "${qcProcessingProfile}" >/dev/null 2>&1; then
    echo \"ffmpeg-qc\" profile already exists.
  else
    python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${qcProcessingProfile} -k /profiles -v "$qcProfile_Ffmpeg"
  fi
fi