#!/bin/bash

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
SUBSYSTEM_PATH="/opt/tandbergtv/cms/workflow/plugins/subsystems"
offerProcessingProfile="/opt/tandbergtv/cms/workflow/preferences/profiles/offer-processing-profile.xml"
resoureMappingProfile="/opt/tandbergtv/cms/workflow/preferences/profiles/resource-mapping-with-template.xml"
mfPackagingProfile="/opt/tandbergtv/cms/workflow/preferences/profiles/mediafirst-packaging-profile.xml"
mediafirstProperties="${SUBSYSTEM_PATH}/mediafirst/resources/properties/MediaFirst.properties"

profileContentPackageWithEventId='<profile name="offer-processing-packageWithEventId">
    <!-- AUTO_CREATE_AND_ASSOCIATE-->
    <offer-processing-type>AUTO_CREATE_AND_ASSOCIATE</offer-processing-type>
    <offer-title-type>MF_Package</offer-title-type>

    <!-- If <offer-searching-criteria> is configured, then it will associate title and offer based on this configuration.
        Otherwise it will base on the metadata enhancement  -->
    <!-- Supports as many as 10 criteria -->
    <offer-searching-criteria>
        <searching-criteria name="criteria1">
            <child-field-name assetType="TITLE">/Fields/CustomFields/CustomField[@name=Event_Id]/@value</child-field-name>
            <offer-field-name assetType="TITLE">/Fields/Identifier/PublicId</offer-field-name>
        </searching-criteria>
    </offer-searching-criteria>
</profile>'

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${offerProcessingProfile} ]; then
  echo "Upgrading $offerProcessingProfile"

  if egrep '<profile\s+name="offer-processing-packageWithEventId">' "${offerProcessingProfile}" >/dev/null 2>&1; then
    echo \"offer-processing-packageWithEventId\" profile already exists.
  else
    python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${offerProcessingProfile} -k /profiles -v "$profileContentPackageWithEventId"
  fi
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${resoureMappingProfile} ]; then
  echo "Upgrading $resoureMappingProfile"

  if egrep '<!DOCTYPE properties SYSTEM' "${resoureMappingProfile}" >/dev/null 2>&1; then
    sed -i '/!DOCTYPE properties SYSTEM/d' ${resoureMappingProfile}
  else
    echo \"resource-mapping-with-template\" profile has been updated.
  fi
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${mfPackagingProfile} ]; then
  echo "Upgrading $mfPackagingProfile"

  if egrep '<!DOCTYPE properties SYSTEM' "${mfPackagingProfile}" >/dev/null 2>&1; then
    sed -i '/!DOCTYPE properties SYSTEM/d' ${mfPackagingProfile}
  else
    echo \"mediafirst-packaging-profile\" profile has been updated.
  fi
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${mediafirstProperties} ]; then
  echo "Upgrading $mediafirstProperties"
  sed -i "/^mediafirst.api.*/d" ${mediafirstProperties}
  sed -i "/^#/{/APIs/d}" ${mediafirstProperties}
  sed -i "s/\r$//g" ${mediafirstProperties}
  sed -i "/^$/d" ${mediafirstProperties}
  if egrep 'mediafirst.token.refresh.time.seconds' "${mediafirstProperties}" >/dev/null 2>&1; then
    echo \"mediafirst.token.refresh.time.seconds\" already exists.
  else
    python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${mediafirstProperties} -k mediafirst.token.refresh.time.seconds -v "300"
  fi
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${mediafirstProperties} -k mediafirst.query.title.status.frequency.seconds -v "20"
fi
