<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">
    <xsl:output method="xml" indent="yes"/>
    <xsl:template name="additionalInfo">
        <xsl:param name="customFieldstoSkip"/>
        <xsl:for-each select="tns:Fields/tns:CustomFields/tns:CustomField">
               <xsl:variable name="origNameAttribute" select="@name"/>
               <xsl:variable name="paramDelimiter">_PARAM_</xsl:variable>
               <xsl:variable name="nameAttribute" select="substring-before(@name, $paramDelimiter)"/>
               <xsl:variable name="nameAttributeWithDelimiter" select="concat($nameAttribute, $paramDelimiter)"/>
             
               <xsl:choose>
                   <xsl:when test="not(contains(@name, $paramDelimiter)) and not(preceding-sibling::*[@name=$origNameAttribute]) 
                       and not(following-sibling::*[starts-with(@name, concat($origNameAttribute, $paramDelimiter))]) and not($customFieldstoSkip=($origNameAttribute))">
                    <!-- 
                           not(contains(@name, $paramDelimiter)): this part applies for the attribute name without the delimiter '_PARAM_'
                           preceding-sibling::*[@name=$origNameAttribute]: check if any element with the same attribute name exists before the element.
                           following-sibling::*[starts-with(@name, concat($origNameAttribute, $paramDelimiter))]: check if any element starting with the attribute name together with the suffix '_PARAM_' exists behind the element.
                    -->
                   <additionalInfo>
                       <xsl:attribute name='name'>
                           <xsl:value-of select="$origNameAttribute" />
                       </xsl:attribute>
                       <xsl:call-template name="createValueElementWithAttribute">
                           <xsl:with-param name="origNameAttribute" select="$origNameAttribute"/>
                           <xsl:with-param name="textValue" select="@value"/>
                           <xsl:with-param name="delimiter" select="$paramDelimiter"/>
                       </xsl:call-template>
                       <xsl:for-each select="following-sibling::*[@name=$origNameAttribute]">
                           <xsl:call-template name="createValueElementWithAttribute">
                               <xsl:with-param name="origNameAttribute" select="@name"/>
                               <xsl:with-param name="textValue" select="@value"/>
                               <xsl:with-param name="delimiter" select="$paramDelimiter"/>
                           </xsl:call-template>
                       </xsl:for-each>
                   </additionalInfo>
                   </xsl:when>
                   <xsl:when test="contains(@name, $paramDelimiter) and not(preceding-sibling::*[starts-with(@name, $nameAttributeWithDelimiter)]) and not($customFieldstoSkip=($origNameAttribute))">
                   <!-- 
                           contains(@name, $paramDelimiter): this part applies for the attribute name with the delimiter '_PARAM_'
                           preceding-sibling::*[starts-with(@name, $nameAttributeWithDelimiter)]: check if any element starting with the attribute name together with the suffix '_PARAM_' exists before the element.
                    -->
                   <additionalInfo>
                       <xsl:attribute name='name'>
                           <xsl:value-of select="$nameAttribute" />
                       </xsl:attribute>
                       <xsl:call-template name="createValueElementWithAttribute">
                           <xsl:with-param name="origNameAttribute" select="$origNameAttribute"/>
                           <xsl:with-param name="textValue" select="@value"/>
                           <xsl:with-param name="delimiter" select="$paramDelimiter"/>
                       </xsl:call-template>
                       <xsl:for-each select="following-sibling::*[starts-with(@name, $nameAttributeWithDelimiter)]">
                           <xsl:call-template name="createValueElementWithAttribute">
                               <xsl:with-param name="origNameAttribute" select="@name"/>
                               <xsl:with-param name="textValue" select="@value"/>
                               <xsl:with-param name="delimiter" select="$paramDelimiter"/>
                           </xsl:call-template>
                       </xsl:for-each>
                   </additionalInfo>
                   </xsl:when>
               </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="createValueElementWithAttribute">
        <xsl:param name="origNameAttribute"/>
        <xsl:param name="textValue"/>
        <xsl:param name="delimiter"/>
        <value>
            <xsl:if test='contains($origNameAttribute, $delimiter)'>
                <xsl:variable name="paramAttributeValue" select="substring-after($origNameAttribute, $delimiter)"/>
                <xsl:attribute name="param">
                    <xsl:value-of select="$paramAttributeValue"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$textValue" />
        </value>
    </xsl:template>
</xsl:stylesheet>