<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="count(/tns:TTVSpec/tns:Group[@type = 'MOVIE' or @type= 'PREVIEW' or @type = 'ENCRYPTED']/tns:Fields/tns:ESNI/tns:Media/tns:Id) = 0">
				<Media/>
			</xsl:when>
			<xsl:when test="count(/tns:TTVSpec/tns:Group[@type = 'MOVIE' or @type= 'PREVIEW' or @type = 'ENCRYPTED']/tns:Fields/tns:ESNI/tns:Media/tns:Id) = 1">
				<xsl:apply-templates select="/tns:TTVSpec/tns:Group[@type = 'MOVIE' or @type= 'PREVIEW' or @type = 'ENCRYPTED']"></xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<Medias>
					<xsl:apply-templates select="/tns:TTVSpec/tns:Group[@type = 'MOVIE' or @type= 'PREVIEW' or @type = 'ENCRYPTED']"></xsl:apply-templates>
				</Medias>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="/tns:TTVSpec/tns:Group[@type = 'MOVIE' or @type= 'PREVIEW' or @type = 'ENCRYPTED']">
			<xsl:if test="tns:Fields/tns:ESNI/tns:Media/tns:Id">
				<Media xmlns="http://www.scte.org/schemas/224/2018" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:audience="urn:scte:224:audience" xmlns:action="urn:scte:224:action">
					<xsl:attribute name="id">
						<xsl:value-of select="tns:Fields/tns:ESNI/tns:Media/tns:Id"></xsl:value-of>
					</xsl:attribute>
				
					<xsl:if test="tns:Fields/tns:Description/tns:Text">
						<xsl:attribute name="description">
							<xsl:value-of select="tns:Fields/tns:Description/tns:Text"></xsl:value-of>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:ESNI/tns:Media/tns:Effective">
						<xsl:attribute name="effective">
							<xsl:value-of select="tns:Fields/tns:ESNI/tns:Media/tns:Effective"></xsl:value-of>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:ESNI/tns:Media/tns:Expires">
						<xsl:attribute name="expires">
							<xsl:value-of select="tns:Fields/tns:ESNI/tns:Media/tns:Expires"></xsl:value-of>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:ESNI/tns:Media/tns:Source">
						<xsl:attribute name="source">
							<xsl:value-of select="tns:Fields/tns:ESNI/tns:Media/tns:Source"></xsl:value-of>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:ESNI/tns:Media/tns:Base">
						<xsl:attribute name="xml:base">
							<xsl:value-of select="tns:Fields/tns:ESNI/tns:Media/tns:Base"></xsl:value-of>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:ESNI/tns:Media/tns:Href">
						<xsl:attribute name="xlink:href">
							<xsl:value-of select="tns:Fields/tns:ESNI/tns:Media/tns:Href"></xsl:value-of>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:ESNI/tns:Media/tns:AltId">
						<xsl:call-template name="split">
							<xsl:with-param name="text" select="tns:Fields/tns:ESNI/tns:Media/tns:AltId"/>
							<xsl:with-param name="elementName">AltID</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
			
					<xsl:for-each select="tns:Fields/tns:ESNI/tns:MediaPoints/tns:MediaPoint">
					<MediaPoint>
						<xsl:if test="./tns:Id">
							<xsl:attribute name="id">
								<xsl:value-of select="./tns:Id"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:Description">
							<xsl:attribute name="description">
								<xsl:value-of select="./tns:Description"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:Base">
							<xsl:attribute name="xml:base">
								<xsl:value-of select="./tns:Base"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:Effective">
							<xsl:attribute name="effective">
								<xsl:value-of select="./tns:Effective"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:Expires">
							<xsl:attribute name="expires">
								<xsl:value-of select="./tns:Expires"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:MatchTime">
							<xsl:attribute name="matchTime">
								<xsl:value-of select="./tns:MatchTime"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:MatchOffset">
							<xsl:attribute name="matchOffset">
								<xsl:value-of select="./tns:MatchOffset"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:Source">
							<xsl:attribute name="source">
								<xsl:value-of select="./tns:Source"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:ExpectedDuration">
							<xsl:attribute name="expectedDuration">
								<xsl:value-of select="./tns:ExpectedDuration"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:Order">
							<xsl:attribute name="order">
								<xsl:value-of select="./tns:Order"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:Reusable">
							<xsl:attribute name="reusable">
								<xsl:value-of select="./tns:Reusable"></xsl:value-of>
							</xsl:attribute>
						</xsl:if>
						<xsl:if test="./tns:SignalMatch">
							<MatchSignal>
								<xsl:if test="./tns:SignalMatch">
									<xsl:attribute name="match">
										<xsl:value-of select="./tns:SignalMatch"></xsl:value-of>
									</xsl:attribute>
								</xsl:if>
								<xsl:if test="./tns:SignalTolerance">
									<xsl:attribute name="signalTolerance">
										<xsl:value-of select="./tns:SignalTolerance"></xsl:value-of>
									</xsl:attribute>
								</xsl:if>
								<xsl:if test="./tns:SignalAssert">
									<xsl:call-template name="split">
										<xsl:with-param name="text" select="./tns:SignalAssert"/>
										<xsl:with-param name="elementName">Assert</xsl:with-param>
									</xsl:call-template>
								</xsl:if>
							</MatchSignal>
						</xsl:if>
						<xsl:if test="./tns:AltId">
							<xsl:call-template name="split">
								<xsl:with-param name="text" select="./tns:AltId"/>
								<xsl:with-param name="elementName">AltID</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						
						<xsl:variable name="mediaPointId" select="./tns:Id"/>
						<xsl:for-each select="ancestor::tns:Fields/tns:ESNI/tns:Policies/tns:Policy/tns:MediaPointId[text()=$mediaPointId]">
							<xsl:variable name="verb" select="parent::tns:Policy/tns:Verb/text()"/>
								<xsl:if test="$verb">
									<xsl:element name="{$verb}">
										<xsl:if test="parent::tns:Policy/tns:Duration">
											<xsl:attribute name="duration">
												<xsl:value-of select="parent::tns:Policy/tns:Duration"></xsl:value-of>
											</xsl:attribute>
										</xsl:if>
										<xsl:if test="parent::tns:Policy/tns:Priority">
											<xsl:attribute name="priority">
												<xsl:value-of select="parent::tns:Policy/tns:Priority"></xsl:value-of>
											</xsl:attribute>
										</xsl:if>
										<Policy>
											<xsl:if test="parent::tns:Policy/tns:Href">
												<xsl:attribute name="xlink:href">
													<xsl:value-of select="parent::tns:Policy/tns:Href"></xsl:value-of>
												</xsl:attribute>
											</xsl:if>
										</Policy>
									</xsl:element>
								</xsl:if>
						</xsl:for-each>
						</MediaPoint>
				</xsl:for-each>
			</Media>
		</xsl:if>
	</xsl:template>

	<xsl:template name="split">
		<xsl:param name="text"/>
		<xsl:param name="elementName"/>
		<xsl:variable name="pText" select="normalize-space(substring-before(concat($text,','),','))"></xsl:variable>
		<xsl:if test="string-length($pText)">
			<xsl:element name="{$elementName}" namespace="http://www.scte.org/schemas/224/2018">
				<xsl:value-of select="$pText"></xsl:value-of>
			</xsl:element>
			<xsl:call-template name="split">
				<xsl:with-param name="text" select="substring-after($text,',')"/>
				<xsl:with-param name="elementName" select="$elementName"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>