<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:esni="http://www.scte.org/schemas/224/2018" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema" xmlns:xslFormatting="urn:xslFormatting" version="1.0">
	<xsl:output method="xml" indent="yes" />
	
	<xsl:template match="/esni:Media">
		<xsl:element name="tns:TTVSpec">
			<!-- Package -->
			<xsl:element name="tns:Group">
				<xsl:attribute name="type">PACKAGE</xsl:attribute>
				<xsl:element name="tns:Fields">
					<xsl:element name="tns:TTVId">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-1"/>
						</xsl:element>
					</xsl:element>
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="@package_asset_id"/>
						</xsl:element>
					</xsl:element>
					<xsl:element name="tns:ProviderInfo">
						<xsl:element name="tns:Identifier">
							<xsl:element name="tns:Id">
								<xsl:value-of select="@provider_id" />
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:Relation">
					<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
					<xsl:element name="tns:Target">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-2"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
			
			<xsl:if test="@id">
				<xsl:call-template name="assetTemplate">
					<xsl:with-param name="assetType" select="@asset_type"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	
	<xsl:template name="assetTemplate">
		<xsl:param name="assetType"></xsl:param>
		<xsl:element name="tns:Group">
			<xsl:attribute name="type">
				<xsl:value-of select="$assetType"></xsl:value-of>
			</xsl:attribute>
		
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="-2" />
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="@asset_id"/>
						</xsl:element>
					</xsl:element>
					<xsl:element name="tns:ProviderInfo">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="@provider_id" />
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:Description">
					<xsl:element name="tns:Text">
						<xsl:value-of select="@description"></xsl:value-of>
					</xsl:element>
				</xsl:element>
				
				<xsl:element name="tns:ESNI">
					<!-- Media -->
					<xsl:element name="tns:Media">
						<xsl:element name="tns:Id">
							<xsl:value-of select="@id"/>
						</xsl:element>
						<xsl:element name="tns:Effective">
							<xsl:value-of select="@effective"/>
						</xsl:element>
						<xsl:element name="tns:Expires">
							<xsl:value-of select="@expires"/>
						</xsl:element>
						<xsl:element name="tns:Base">
							<xsl:value-of select="@xml:base"/>
						</xsl:element>
						<xsl:element name="tns:Source">
							<xsl:value-of select="@source"/>
						</xsl:element>
						<xsl:element name="tns:Href">
							<xsl:value-of select="@xlink:href"/>
						</xsl:element>
						<xsl:element name="tns:AltId">
							<xsl:for-each select="esni:AltID">
								<xsl:call-template name="concat"></xsl:call-template>
							</xsl:for-each>
						</xsl:element>
					</xsl:element>
					
					<!-- MediaPoints -->
					<xsl:element name="tns:MediaPoints">
						<xsl:for-each select="esni:MediaPoint">
							<xsl:element name="tns:MediaPoint">
								<xsl:element name="tns:Id">
									<xsl:value-of select="@id"/>
								</xsl:element>
								<xsl:element name="tns:OriginalMediaPointId">
									<xsl:value-of select="@original_id"/>
								</xsl:element>
								<xsl:element name="tns:Description">
									<xsl:value-of select="@description"/>
								</xsl:element>
								<xsl:element name="tns:Base">
									<xsl:value-of select="@xml:base"/>
								</xsl:element>
								<xsl:element name="tns:Effective">
									<xsl:value-of select="@effective"/>
								</xsl:element>
								<xsl:element name="tns:Expires">
									<xsl:value-of select="@expires"/>
								</xsl:element>
								<xsl:element name="tns:MatchTime">
									<xsl:value-of select="@matchTime"/>
								</xsl:element>
								<xsl:element name="tns:MatchOffset">
									<xsl:value-of select="@matchOffset"/>
								</xsl:element>
								<xsl:element name="tns:Source">
									<xsl:value-of select="@source"/>
								</xsl:element>
								<xsl:element name="tns:ExpectedDuration">
									<xsl:value-of select="@expectedDuration"/>
								</xsl:element>
								<xsl:element name="tns:Order">
									<xsl:value-of select="@order"/>
								</xsl:element>
								<xsl:element name="tns:Reusable">
									<xsl:value-of select="@reusable"/>
								</xsl:element>
								<xsl:element name="tns:SignalMatch">
									<xsl:value-of select="esni:MatchSignal/@match"/>
								</xsl:element>
								<xsl:element name="tns:SignalTolerance">
									<xsl:value-of select="esni:MatchSignal/@signalTolerance"/>
								</xsl:element>
								<xsl:element name="tns:SignalAssert">
									<xsl:for-each select="esni:MatchSignal/esni:Assert">
										<xsl:call-template name="concat"></xsl:call-template>
									</xsl:for-each>
								</xsl:element>
								<xsl:element name="tns:AltId">
									<xsl:for-each select="esni:AltID">
										<xsl:call-template name="concat"></xsl:call-template>
									</xsl:for-each>
								</xsl:element>
							</xsl:element>
						</xsl:for-each>
					</xsl:element>
				
					<!-- Policies -->
					<xsl:element name="tns:Policies">
						<xsl:for-each select="esni:MediaPoint//esni:Policy">
							<xsl:element name="tns:Policy">
								<xsl:element name="tns:MediaPointId">
									<xsl:value-of select="ancestor::esni:MediaPoint/@id"></xsl:value-of>
								</xsl:element>
								<xsl:element name="tns:OriginalMediaPointId">
									<xsl:value-of select="ancestor::esni:MediaPoint/@original_id"></xsl:value-of>
								</xsl:element>
								<xsl:element name="tns:Verb">
									<xsl:value-of select="name(..)"></xsl:value-of>
								</xsl:element>
								<xsl:element name="tns:Duration">
									<xsl:value-of select="../@duration"></xsl:value-of>
								</xsl:element>
								<xsl:element name="tns:Priority">
									<xsl:value-of select="../@priority"></xsl:value-of>
								</xsl:element>
								<xsl:element name="tns:Href">
									<xsl:value-of select="@xlink:href"></xsl:value-of>
								</xsl:element>
							</xsl:element>
						</xsl:for-each>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	<xsl:template name="concat">
		<xsl:variable name="value" select="."/>
		<xsl:choose>
			<xsl:when test="position() = last()">
				<xsl:value-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
				<xsl:text>, </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>