<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">

	<xsl:template name="AMS_1">
		<xsl:if test="Fields/Version/Major">
			<xsl:attribute name="providerVersionNum">
				<xsl:value-of select="Fields/Version/Major"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="Fields/Version/Minor">
			<xsl:attribute name="internalVersionNum">
				<xsl:value-of select="Fields/Version/Minor"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="Fields/CreationInfo/CreateDate">
			<xsl:attribute name="creationDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="Fields/CreationInfo/CreateDate"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/Fields/Rights/LicensingWindowStart">
			<xsl:attribute name="startDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowStart"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/Fields/Rights/LicensingWindowEnd">
			<xsl:attribute name="endDateTime">
				<xsl:call-template name="endDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowEnd"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="Fields/ProviderInfo/Identifier/Id and Fields/Identifier/Id">
			<core:AlternateId identifierSystem="VOD1.1">
				<xsl:value-of select="concat('vod://',Fields/ProviderInfo/Identifier/Id,'/',Fields/Identifier/Id)"/>
			</core:AlternateId>
		</xsl:if>
<!-- 		<xsl:if test="Fields/ISAN"> -->
<!-- 			<core:AlternateId identifierSystem="ISAN"> -->
<!-- 				<xsl:value-of select="Fields/ISAN"/> -->
<!-- 			</core:AlternateId> -->
<!-- 		</xsl:if> -->
	</xsl:template>

	<xsl:template name="AMS_2">
		<xsl:if test="Fields/AssetName">
			<core:AssetName deprecated="true">
				<xsl:value-of select="Fields/AssetName"/>
			</core:AssetName>
		</xsl:if>
		<xsl:if test="Fields/ProductInfo/Name">
			<core:Product deprecated="true">
				<xsl:value-of select="Fields/ProductInfo/Name"/>
			</core:Product>
		</xsl:if>		
		<xsl:if test="Fields/ProviderInfo/Name">
			<core:Provider deprecated="true">
				<xsl:value-of select="Fields/ProviderInfo/Name"/>
			</core:Provider>
		</xsl:if>
		<xsl:if test="Fields/Description/Text">
			<core:Description deprecated="true">
				<xsl:choose>
					<xsl:when test="string-length(Fields/Description/Text) > 100">
						<xsl:value-of select="substring(Fields/Description/Text, 0, 100)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Fields/Description/Text"/>
					</xsl:otherwise>
				</xsl:choose>
			</core:Description>
		</xsl:if>
		
<!-- 		<core:Ext>
			<xsl:apply-templates select="Fields/CustomFields/CustomField" />
		</core:Ext> -->
	</xsl:template>

	<xsl:template name="ContentAsset">
		<xsl:param name="masterSourceRef"/>
		<!--<xsl:attribute name="uriId"><xsl:value-of select="concat( Fields/ProviderInfo/Identifier/Id, '/Asset/', Fields/Identifier/Id )"/></xsl:attribute>-->
		<xsl:call-template name="encodeUri">
			<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
			<xsl:with-param name="assetType" select="'/Asset/'" />
			<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
		</xsl:call-template>

		<xsl:call-template name="AMS_1" />
		<xsl:call-template name="AMS_2" />
		
		<core:Ext>
			<ericsson:AudioVideoAssetExt>
				<xsl:if test="Fields/Video/AVContainer">
					<ericsson:AVContainer>
						<xsl:value-of select="Fields/Video/AVContainer"/>
					</ericsson:AVContainer>
				</xsl:if>
				<xsl:if test="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeOne'] or UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeTwo'] or UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeThree'] or UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeFour'] or Fields/Avails/Avail/Id or Fields/Avails/Avail/Scope">
					<ericsson:Avail>					
						<xsl:if test="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeOne']">
							<ericsson:TimeValue>
								<xsl:value-of select="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeOne']/@value"/>
							</ericsson:TimeValue>
						</xsl:if>
						<xsl:if test="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeTwo']">
							<ericsson:TimeValue>
								<xsl:value-of select="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeTwo']/@value"/>
							</ericsson:TimeValue>
						</xsl:if>
						<xsl:if test="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeThree']">
							<ericsson:TimeValue>
								<xsl:value-of select="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeThree']/@value"/>
							</ericsson:TimeValue>
						</xsl:if>
						<xsl:if test="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeFour']">
							<ericsson:TimeValue>
								<xsl:value-of select="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeFour']/@value"/>
							</ericsson:TimeValue>
						</xsl:if>
						<xsl:if test="Fields/Avails/Avail/Id">
							<ericsson:ID>
								<xsl:value-of select="Fields/Avails/Avail/Id"/>
							</ericsson:ID>
						</xsl:if>
						<xsl:if test="Fields/Avails/Avail/Scope">
							<ericsson:Scope>
								<xsl:value-of select="Fields/Avails/Avail/Scope"/>
							</ericsson:Scope>
						</xsl:if>					
					</ericsson:Avail>
				</xsl:if>
				<xsl:if test="Fields/Restriction/Roll">
					<ericsson:RollsRestricted>
						<xsl:value-of select="Fields/Restriction/Roll"/>
					</ericsson:RollsRestricted>
				</xsl:if>
				<xsl:if test="Fields/Restriction/Content">
					<ericsson:ContentRestricted>
						<xsl:value-of select="Fields/Restriction/Content"/>
					</ericsson:ContentRestricted>
				</xsl:if>
				<xsl:if test="Fields/EquipCapabilityProfileList/EquipCapabilityProfile">
					<xsl:for-each select="Fields/EquipCapabilityProfileList/EquipCapabilityProfile">
						<ericsson:EquipmentCapabilityProfile>
							<xsl:value-of select="."/>
						</ericsson:EquipmentCapabilityProfile>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="Fields/Video/AlternateBitRateList/AlternateBitRate">
					<ericsson:AlternateBitRate>
						<xsl:value-of select="Fields/Video/AlternateBitRateList/AlternateBitRate"/>
					</ericsson:AlternateBitRate>
				</xsl:if>
				<xsl:if test="Fields/Encryption/Asset/Id">
					<xsl:choose>
						<xsl:when test="Fields/CustomFields/CustomField[@name='EncryptionSystemAssetId']/Value != ''">
							<ericsson:EncryptionSystemAssetId>
								<xsl:value-of select="Fields/CustomFields/CustomField[@name='EncryptionSystemAssetId']/Value"/>
							</ericsson:EncryptionSystemAssetId>
						</xsl:when>
						<xsl:otherwise>
							<ericsson:EncryptionSystemAssetId>
								<xsl:value-of select="concat($Title/Fields/ProviderInfo/Identifier/Id, '/', Fields/Identifier/Id)"/>
							</ericsson:EncryptionSystemAssetId>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="$Title/Fields/OSVOD/MinOnDiskDuration or $Title/Fields/OSVOD/MaxOnDiskDuration or $Title/Fields/OSVOD/MaxOnDiskDurationAfterView or Fields/Rights/MaximumCopiesAllowed or $Title/Fields/OSVOD/MaxConcurrentViewsAllowed or Fields/Restriction/Roll or Fields/Restriction/Content or Fields/Rights/MaxPlayCount or Fields/Rights/DownloadWindowOffset or Fields/Rights/DownloadPurchasePolicy or $Title/Fields/OSVOD/BurnAllowed or $Title/Fields/OSVOD/MaxBurnsAllowed or Fields/Restriction/AuthorizedDeliveryMethods/AuthorizedDeliveryMethod or Fields/Restriction/AuthorizedDeliveryNetworks/AuthorizedDeliveryNetwork">
					<ericsson:UsageControlInfo>
						<xsl:if test="$Title/Fields/OSVOD/MinOnDiskDuration">
							<ericsson:OnDiskMinDuration>
								<xsl:value-of select="$Title/Fields/OSVOD/MinOnDiskDuration"/>
							</ericsson:OnDiskMinDuration>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/MaxOnDiskDuration">
							<ericsson:OnDiskMaxDuration>
								<xsl:value-of select="$Title/Fields/OSVOD/MaxOnDiskDuration"/>
							</ericsson:OnDiskMaxDuration>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/MaxOnDiskDurationAfterView">
							<ericsson:OnDiskMaxDurationAfterView>
								<xsl:value-of select="$Title/Fields/OSVOD/MaxOnDiskDurationAfterView"/>
							</ericsson:OnDiskMaxDurationAfterView>
						</xsl:if>
						<xsl:if test="Fields/Rights/MaximumCopiesAllowed">
							<ericsson:MaximumCopiesAllowed>
								<xsl:value-of select="Fields/Rights/MaximumCopiesAllowed"/>
							</ericsson:MaximumCopiesAllowed>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/MaxConcurrentViewsAllowed">
							<ericsson:MaximumConcurrentViewsAllowed>
								<xsl:value-of select="$Title/Fields/OSVOD/MaxConcurrentViewsAllowed"/>
							</ericsson:MaximumConcurrentViewsAllowed>
						</xsl:if>
						<xsl:if test="Fields/Restriction/Roll">
							<ericsson:RollsRestricted>
								<xsl:value-of select="Fields/Restriction/Roll"/>
							</ericsson:RollsRestricted>
						</xsl:if>
						<xsl:if test="Fields/Restriction/Content">
							<ericsson:ContentRestricted>
								<xsl:value-of select="Fields/Restriction/Content"/>
							</ericsson:ContentRestricted>
						</xsl:if>
						<xsl:if test="Fields/Rights/MaxPlayCount">
							<ericsson:MaxNumberOfPlays>
								<xsl:value-of select="Fields/Rights/MaxPlayCount"/>
							</ericsson:MaxNumberOfPlays>
						</xsl:if>
						<xsl:if test="Fields/Rights/DownloadWindowOffset">
							<ericsson:DownloadWindowOffset>
								<xsl:value-of select="Fields/Rights/DownloadWindowOffset"/>
							</ericsson:DownloadWindowOffset>
						</xsl:if>
						<xsl:if test="Fields/Rights/DownloadPurchasePolicy">
							<ericsson:DownloadPurchasePolicy>
								<xsl:value-of select="Fields/Rights/DownloadPurchasePolicy"/>
							</ericsson:DownloadPurchasePolicy>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/BurnAllowed">
							<ericsson:BurnAllowed>
								<xsl:value-of select="$Title/Fields/OSVOD/BurnAllowed"/>
							</ericsson:BurnAllowed>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/MaxBurnsAllowed">
							<ericsson:MaxBurnsAllowed>
								<xsl:value-of select="$Title/Fields/OSVOD/MaxBurnsAllowed"/>
							</ericsson:MaxBurnsAllowed>
						</xsl:if>
						<xsl:if test="Fields/Restriction/AuthorizedDeliveryMethods/AuthorizedDeliveryMethod">
							<xsl:for-each select="Fields/Restriction/AuthorizedDeliveryMethods/AuthorizedDeliveryMethod">
								<ericsson:DeliveryMethod>
									<xsl:value-of select="."/>
								</ericsson:DeliveryMethod>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="Fields/Restriction/AuthorizedDeliveryNetworks/AuthorizedDeliveryNetwork">
							<xsl:for-each select="Fields/Restriction/AuthorizedDeliveryNetworks/AuthorizedDeliveryNetwork">
								<ericsson:DeliveryNetwork>
									<xsl:value-of select="."/>
								</ericsson:DeliveryNetwork>
							</xsl:for-each>
						</xsl:if>
					</ericsson:UsageControlInfo>
				</xsl:if>
			</ericsson:AudioVideoAssetExt>
			<xsl:apply-templates select="Fields/CustomFields/CustomField" />
		</core:Ext>
		
		<xsl:if test="Fields/Derived/SourceAssetId != '' and Fields/Derived/SourceProviderId != ''">
			<core:MasterSourceRef>
				<xsl:call-template name="encodeUri">
					<xsl:with-param name="providerId" select="Fields/Derived/SourceProviderId" />
					<xsl:with-param name="assetType" select="'/Asset/'" />
					<xsl:with-param name="fieldId" select="Fields/Derived/SourceAssetId" />
				</xsl:call-template>
			</core:MasterSourceRef>
		</xsl:if>
		
		<xsl:if test="Fields/Content/Locator/Uri !=''">
			<content:SourceUrl>
				<xsl:value-of select="Fields/Content/Locator/Uri"/>
			</content:SourceUrl>
		</xsl:if>
		<xsl:if test="Fields/Content/Size/length">
			<content:ContentFileSize>
				<xsl:value-of select="Fields/Content/Size/length"/>
			</content:ContentFileSize>
		</xsl:if>
		<xsl:if test="Fields/Content/Checksum">
			<content:ContentCheckSum>
				<xsl:value-of select="Fields/Content/Checksum"/>
			</content:ContentCheckSum>
		</xsl:if>
		<xsl:if test="$Title/Fields/PropagationPriority" >
			<content:PropagationPriority>
				<!-- grab any one (max??) -->
				<xsl:value-of select="$Title/Fields/PropagationPriority"/>
			</content:PropagationPriority>
		</xsl:if>
		<xsl:if test="Fields/Content/Locator/Path !=''">
			<content:ContentRef>
				<xsl:value-of select="Fields/Content/Locator/Path"/>
			</content:ContentRef>
		</xsl:if>
		<xsl:if test="Fields/Content/MIMEType">
			<content:MediaType>
				<xsl:value-of select="Fields/Content/MIMEType"/>
			</content:MediaType>
		</xsl:if>

	</xsl:template>

	<xsl:template name="startDateTime">
		<xsl:param name="dateString" />
		<xsl:choose>
			<xsl:when test="string-length($dateString) = 10"><xsl:value-of select="concat($dateString,'T00:00:00Z')"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="concat($dateString,'Z')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="endDateTime">
		<xsl:param name="dateString" />
		<xsl:choose>
			<xsl:when test="string-length($dateString) = 10"><xsl:value-of select="concat($dateString,'T23:59:59Z')"/></xsl:when>
			<xsl:when test="contains($dateString,'T00:00:00')"><xsl:value-of select="replace($dateString,'T00:00:00','T23:59:59Z')"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="concat($dateString,'Z')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*|@*" mode="stringToDuration">
		<xsl:variable name="hours" select="concat('PT',substring-before(., ':'),'H')"/>
		<xsl:variable name="remaining" select="substring-after(., ':')"/>
		<xsl:variable name="minutes" select="concat(substring-before($remaining, ':'),'M')"/>
		<xsl:variable name="seconds" select="concat(substring-after($remaining, ':'),'S')"/>
		<xsl:value-of select="concat($hours,$minutes,$seconds)"/>
	</xsl:template>

	<xsl:template name="durationInSecs">
		<xsl:param name="duration" />

	    <xsl:variable name="hours">
	      <xsl:value-of select="substring($duration,1,2)" />
    	</xsl:variable>
	    <xsl:variable name="minutes">
	      <xsl:value-of select="substring($duration,4,2)" />
    	</xsl:variable>
	    <xsl:variable name="seconds">
	      <xsl:value-of select="substring($duration,7,2)" />
    	</xsl:variable>
    	
    	<xsl:value-of select="(number($hours) * 60 * 60) + (number($minutes) * 60) + number($seconds)"/>
    	
	</xsl:template>

	<xsl:template match="Fields/CustomFields/CustomField">
		<xsl:variable name="app" select="$Title/Fields/ProductInfo/Name"/>
		<xsl:variable name="name" select="@name"/>
		<xsl:variable name="value">
			<xsl:choose>
				<xsl:when test="BooleanValue">
					<xsl:value-of select="BooleanValue"/>
				</xsl:when>
				<xsl:when test="Value">
					<xsl:value-of select="Value"/>
				</xsl:when>
				<xsl:when test="DatetimeValue">
					<xsl:value-of select="DatetimeValue"/>
				</xsl:when>
				<xsl:when test="IntegerValue">
					<xsl:value-of select="IntegerValue"/>
				</xsl:when>
				<xsl:when test="TimeValue">
					<xsl:value-of select="TimeValue"/>
				</xsl:when>
				<xsl:when test="FloatValue">
					<xsl:value-of select="FloatValue"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:call-template name="customField">
			<xsl:with-param name="app" select="$app" />
			<xsl:with-param name="name" select="@name" />
			<xsl:with-param name="value" select="$value" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="customField">
		<xsl:param name="app"/>
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		
		<xsl:if test="$value != ''">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app"/></xsl:attribute>
				<xsl:attribute name="Name"><xsl:value-of select="$name"/></xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$value"/></xsl:attribute>
			</App_Data>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="ancestorAssetType">
		<xsl:param name="assetId"/>
		<xsl:for-each select="/ECMFSpec/Package/Movie | /ECMFSpec/Package/Preview | /ECMFSpec/Package/Encrypted">
			<xsl:if test="Fields/Identifier/Id = $assetId">
				<xsl:choose>
					<xsl:when test="Fields/Derived/SourceAssetId">
						<xsl:variable name="aat">
							<xsl:call-template name="ancestorAssetType">
								<xsl:with-param name="assetId" select="Fields/Derived/SourceAssetId" />
							</xsl:call-template>
			        	</xsl:variable>
			        	<xsl:choose>
			        		<xsl:when test="$aat != ''">
			        			<xsl:value-of select="$aat" />
			        		</xsl:when>
			        		<xsl:otherwise>
			        			<xsl:value-of select="Fields/CustomFields/CustomField[@name='ParentAssetType']/Value" />
			        		</xsl:otherwise>
			        	</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Fields/AssetClass"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="encodeCategoryUri">
		<!-- uriId should follow the URI Style. so after encoded, some special characters should like '/' ==> '%2F', '%2F' ==> '%252F' .
		As '/' and '%2F' has special function for category in CL format, then it should replace back '%2F' ==> '/', '%252F' ==> '%2F' after encoded -->
		<xsl:attribute name="uriId">
			<!-- <xsl:value-of select="concat( $PackageProviderId, '/Category/', Text)"/> -->
			<xsl:value-of select="concat( encode-for-uri($PackageProviderId), '/Category/', replace( replace(encode-for-uri(Text), '%2F', '/'), '%252F', '%2F' ) )"/>
		</xsl:attribute>
	</xsl:template>
	
	<xsl:template name="encodeUri">
		<!-- uriId should follow the URI Style. so after encoded, some special characters should like '/' ==> '%2F', '%2F' ==> '%252F' -->
		<xsl:param name="providerId"/>
		<xsl:param name="assetType"/>
		<xsl:param name="fieldId"/>
		<xsl:attribute name="uriId">
			<xsl:value-of select="concat( encode-for-uri($providerId), $assetType, $fieldId )"/>
		</xsl:attribute>
	</xsl:template>
</xsl:stylesheet>