<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1"
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1"
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1"
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1"
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1"
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:ad="urn:cablelabs:md:xsd:ad:3.0" xmlns:adid="http://www.ad-id.org/schemas/adid/2.0">

	<xsl:template
		match="/ECMFSpec/Package/Title/Fields/Advertisements/Advertisement">
		<Asset xsi:type="ad:AdvertisementType">
			<xsl:attribute name="uriId">
				<xsl:value-of select="$TitleUriId" />
			</xsl:attribute>
			<xsl:call-template name="AMS_1_Title" />
			<xsl:call-template name="AMS_2_Title" />
			<core:Ext />
			<xsl:for-each select="$Title/Fields/Rating/RatingValues/RatingValue">
				<title:Rating>
					<xsl:choose>
						<xsl:when test="System">
							<xsl:attribute name="ratingSystem">
								<xsl:value-of select="System" />
							</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="exists(index-of(('G','PG','PG-13','R','NC-17'),.))">
									<xsl:attribute name="ratingSystem">MPAA</xsl:attribute>
								</xsl:when>
								<xsl:when test="starts-with(.,'TV')">
									<xsl:attribute name="ratingSystem">TV</xsl:attribute>
								</xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="Value" />
				</title:Rating>
			</xsl:for-each>

			<ad:AdId>
				<xsl:attribute name="cid">
						<xsl:value-of select="Cid" />
					</xsl:attribute>
				<xsl:attribute name="code">
						<xsl:value-of select="$Title/Fields/AdId" />
					</xsl:attribute>
				<xsl:if test="BrandAndProduct">
					<adid:brand_and_Product>
						<xsl:if test="BrandAndProduct/IndustryGroup">
							<adid:industry_group>
								<xsl:value-of select="BrandAndProduct/IndustryGroup" />
							</adid:industry_group>
						</xsl:if>
						<xsl:if test="BrandAndProduct/SubCategory">
							<adid:sub_category>
								<xsl:value-of select="BrandAndProduct/SubCategory" />
							</adid:sub_category>
						</xsl:if>
						<xsl:if test="BrandAndProduct/MajorCategory">
							<adid:major_category>
								<xsl:value-of select="BrandAndProduct/MajorCategory" />
							</adid:major_category>
						</xsl:if>
						<xsl:if test="BrandAndProduct/ProductCategory">
							<adid:product_category>
								<xsl:value-of select="BrandAndProduct/ProductCategory" />
							</adid:product_category>
						</xsl:if>
						<xsl:if test="BrandAndProduct/Ext/ExtField">
							<adid:ext>
								<xsl:value-of select="BrandAndProduct/Ext/ExtField" />
							</adid:ext>
						</xsl:if>
					</adid:brand_and_Product>
				</xsl:if>
				<xsl:if test="Code">
					<adid:code>
						<xsl:value-of select="Code" />
					</adid:code>
				</xsl:if>
				<xsl:if test="Contact">
					<adid:contacts>
						<xsl:if test="AdsExtContact/ContactType">
							<adid:contact_type>
								<xsl:value-of select="AdsExtContact/ContactType" />
							</adid:contact_type>
						</xsl:if>
						<xsl:if test="AdsExtContact/Company">
							<adid:company>
								<xsl:value-of select="AdsExtContact/Company" />
							</adid:company>
						</xsl:if>
						<xsl:if test="AdsExtContact/ContactRole">
							<adid:contact_role>
								<xsl:value-of select="AdsExtContact/ContactRole" />
							</adid:contact_role>
						</xsl:if>

						<xsl:choose>
							<xsl:when test="Contact/DisplayName">
								<adid:name>
									<xsl:value-of select="Contact/DisplayName" />
								</adid:name>
							</xsl:when>
							<xsl:otherwise>
								<xsl:if test="Contact/FirstName or Contact/LastName or Contact/MiddleName">
									<adid:name>
										<xsl:value-of separator=" "
											select="Contact/FirstName/., Contact/MiddleName/., Contact/LastName/." />
									</adid:name>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>

						<xsl:if test="AdsExtContact/Title">
							<adid:title>
								<xsl:value-of select="AdsExtContact/Title" />
							</adid:title>
						</xsl:if>
						<xsl:if
							test="Contact/Address/Line1 or Contact/Address/Line2 or Contact/Address/Zip or Contact/Address/Place/Region or Contact/Address/Place/Country or Contact/Address/Place/Coordiantes">
							<adid:address>
								<xsl:value-of separator=" ,"
									select="Contact/Address/Line1/.,  Contact/Address/Line2/.,Contact/Address/Zip/., Contact/Address/Place/Region/., Contact/Address/Place/Country/. ,Contact/Address/Place/Coordiantes/." />
							</adid:address>
						</xsl:if>
						<xsl:if test="AdsExtContact/Phone">
							<adid:phone>
								<xsl:value-of select="AdsExtContact/Phone" />
							</adid:phone>
						</xsl:if>
						<xsl:if test="AdsExtContact/Fax">
							<adid:fax>
								<xsl:value-of select="AdsExtContact/Fax" />
							</adid:fax>
						</xsl:if>
						<xsl:if test="Contact/Email">
							<adid:email>
								<xsl:value-of select="Contact/Email" />
							</adid:email>
						</xsl:if>
						<xsl:if test="AdsExtContact/Notes">
							<adid:notes>
								<xsl:value-of select="AdsExtContact/Notes" />
							</adid:notes>
						</xsl:if>
						<xsl:if test="AdsExtContact/Ext/ExtField">
							<adid:Ext>
								<xsl:value-of select="AdsExtContact/Ext/ExtField" />
							</adid:Ext>
						</xsl:if>
					</adid:contacts>
				</xsl:if>
				<adid:prefix>
					<xsl:attribute name="pid">
						<xsl:value-of select="Prefix" />
					</xsl:attribute>
				</adid:prefix>
				<xsl:if test="Slate">
					<adid:slate>
						<xsl:if test="Slate/AdStatus">
							<adid:ad_status>
								<xsl:value-of select="Slate/AdStatus" />
							</adid:ad_status>
						</xsl:if>
						<xsl:if test="Slate/AdTitle">
							<adid:ad_title>
								<xsl:value-of select="Slate/AdTitle" />
							</adid:ad_title>
						</xsl:if>
						<xsl:if test="Slate/Advertiser">
							<adid:advertiser>
								<xsl:value-of select="Slate/Advertiser" />
							</adid:advertiser>
						</xsl:if>
						<xsl:if test="Slate/AFD">
							<adid:AFD>
								<xsl:value-of select="Slate/AFD" />
							</adid:AFD>
						</xsl:if>
						<xsl:if test="Slate/AgencyName">
							<adid:agency_name>
								<xsl:value-of select="Slate/AgencyName" />
							</adid:agency_name>
						</xsl:if>
						<xsl:if test="Slate/AgencyRole">
							<adid:agency_role>
								<xsl:value-of select="Slate/AgencyRole" />
							</adid:agency_role>
						</xsl:if>
						<xsl:if test="Slate/Audio">
							<adid:audio>
								<xsl:value-of select="Slate/Audio" />
							</adid:audio>
						</xsl:if>
						<xsl:if test="Slate/Bleed">
							<adid:bleed>
								<xsl:value-of select="Slate/Bleed" />
							</adid:bleed>
						</xsl:if>
						<xsl:if test="Slate/Brand">
							<adid:brand>
								<xsl:value-of select="Slate/Brand" />
							</adid:brand>
						</xsl:if>
						<xsl:if test="Slate/Campaign">
							<adid:campaign>
								<xsl:value-of select="Slate/Campaign" />
							</adid:campaign>
						</xsl:if>
						<xsl:if test="Slate/ClosedCaptioned">
							<adid:closed_captioned>
								<xsl:value-of select="Slate/ClosedCaptioned" />
							</adid:closed_captioned>
						</xsl:if>
						<xsl:if test="Slate/ColorType">
							<adid:color_type>
								<xsl:value-of select="Slate/ColorType" />
							</adid:color_type>
						</xsl:if>
						<xsl:if test="Slate/Copyright">
							<adid:copyright>
								<xsl:value-of select="Slate/Copyright" />
							</adid:copyright>
						</xsl:if>
						<xsl:if test="Slate/Created">
							<adid:created>
								<xsl:value-of select="Slate/Created" />
							</adid:created>
						</xsl:if>
						<xsl:if test="Slate/Creator">
							<adid:creator>
								<xsl:value-of select="Slate/Creator" />
							</adid:creator>
						</xsl:if>
						<xsl:if test="Slate/DerivativeType">
							<adid:derivative_type>
								<xsl:value-of select="Slate/DerivativeType" />
							</adid:derivative_type>
						</xsl:if>
						<xsl:if test="Slate/EndDate">
							<adid:end_date>
								<xsl:value-of select="Slate/EndDate" />
							</adid:end_date>
						</xsl:if>
						<xsl:if test="Slate/Expandable">
							<adid:expandable>
								<xsl:value-of select="Slate/Expandable" />
							</adid:expandable>
						</xsl:if>
						<xsl:if test="Slate/HDFlag">
							<adid:hd_flag>
								<xsl:value-of select="number(boolean(Slate/HDFlag))" />
							</adid:hd_flag>
						</xsl:if>
						<xsl:if test="Slate/JobNumber">
							<adid:job_number>
								<xsl:value-of select="Slate/JobNumber" />
							</adid:job_number>
						</xsl:if>
						<xsl:if test="Slate/Length">
							<adid:length>
								<xsl:value-of select="Slate/Length" />
							</adid:length>
						</xsl:if>
						<xsl:if test="Slate/ParentChild">
							<adid:parent_child>
								<xsl:value-of select="Slate/ParentChild" />
							</adid:parent_child>
						</xsl:if>
						<xsl:if test="Slate/MediaType">
							<adid:media_type>
								<xsl:value-of select="Slate/MediaType" />
							</adid:media_type>
						</xsl:if>
						<xsl:for-each select="Slate/Medium">
							<adid:medium>
								<xsl:value-of select="." />
							</adid:medium>
						</xsl:for-each>
						<xsl:if test="Slate/Notes">
							<adid:notes>
								<xsl:value-of select="Slate/Notes" />
							</adid:notes>
						</xsl:if>
						<xsl:if test="Slate/Parent">
							<adid:parent>
								<xsl:value-of select="Slate/Parent" />
							</adid:parent>
						</xsl:if>
						<xsl:if test="Slate/Product">
							<adid:product>
								<xsl:value-of select="Slate/Product" />
							</adid:product>
						</xsl:if>
						<xsl:if test="Slate/RecordType">
							<adid:record_type>
								<xsl:value-of select="Slate/RecordType" />
							</adid:record_type>
						</xsl:if>
						<xsl:if test="Slate/SDFlag">
							<adid:sd_flag>
								<xsl:value-of select="number(boolean(Slate/SDFlag))" />
							</adid:sd_flag>
						</xsl:if>
						<xsl:if test="Slate/StartDate">
							<adid:start_date>
								<xsl:value-of select="Slate/StartDate" />
							</adid:start_date>
						</xsl:if>
						<xsl:if test="Slate/ThreedFlag">
							<adid:threed_flag>
								<xsl:value-of select="number(boolean(Slate/ThreedFlag))" />
							</adid:threed_flag>
						</xsl:if>
						<xsl:if test="Slate/UrlLink">
							<adid:url_link>
								<xsl:value-of select="Slate/UrlLink" />
							</adid:url_link>
						</xsl:if>
						<xsl:if test="Slate/Version">
							<adid:version>
								<xsl:value-of select="Slate/Version" />
							</adid:version>
						</xsl:if>
						<xsl:if test="Slate/Ext/ExtField">
							<Ext>
								<xsl:value-of select="Slate/Ext/ExtField" />
							</Ext>
						</xsl:if>
					</adid:slate>
				</xsl:if>
			</ad:AdId>
		</Asset>
	</xsl:template>

	<xsl:template name="AMS_1_Title">
		<xsl:if test="$Title/Fields/Version/Major">
			<xsl:attribute name="providerVersionNum">
				<xsl:value-of select="$Title/Fields/Version/Major" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="$Title/Fields/Version/Minor">
			<xsl:attribute name="internalVersionNum">
				<xsl:value-of select="$Title/Fields/Version/Minor" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="$Title/Fields/CreationInfo/CreateDate">
			<xsl:attribute name="creationDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/CreationInfo/CreateDate" />
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>

		<xsl:if test="$Title/Fields/Rights/LicensingWindowStart">
			<xsl:attribute name="startDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowStart" />
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>

		<xsl:if test="$Title/Fields/Rights/LicensingWindowEnd">
			<xsl:attribute name="endDateTime">
				<xsl:call-template name="endDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowEnd" />
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>

		<xsl:if
			test="$Title/Fields/ProviderInfo/Identifier/Id and $Title/Fields/Identifier/Id">
			<core:AlternateId identifierSystem="VOD1.1">
				<xsl:value-of
					select="concat('vod://',$Title/Fields/ProviderInfo/Identifier/Id,'/',$Title/Fields/Identifier/Id)" />
			</core:AlternateId>
		</xsl:if>
	</xsl:template>

	<xsl:template name="AMS_2_Title">
		<xsl:if test="$Title/Fields/AssetName">
			<core:AssetName deprecated="true">
				<xsl:value-of select="$Title/Fields/AssetName" />
			</core:AssetName>
		</xsl:if>
		<xsl:if test="$Title/Fields/ProductInfo/Name">
			<core:Product deprecated="true">
				<xsl:value-of select="$Title/Fields/ProductInfo/Name" />
			</core:Product>
		</xsl:if>
		<xsl:if test="$Title/Fields/ProviderInfo/Name">
			<core:Provider>
				<xsl:value-of select="$Title/Fields/ProviderInfo/Name" />
			</core:Provider>
		</xsl:if>
		<xsl:if test="$Title/Fields/Description/Text">
			<core:Description deprecated="true">
				<xsl:choose>
					<xsl:when test="string-length($Title/Fields/Description/Text) > 100">
						<xsl:value-of select="substring($Title/Fields/Description/Text, 0, 100)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$Title/Fields/Description/Text" />
					</xsl:otherwise>
				</xsl:choose>
			</core:Description>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>