<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xsi:noNamespaceSchemaLocation="ECMFSpec.xsd"
	version="2.0">

	<xsl:import href="to/packageMD.xsl"/>
	<xsl:import href="to/titleMD.xsl"/>
	<xsl:import href="to/movieMD.xsl"/>
	<xsl:import href="to/previewMD.xsl"/>
	<xsl:import href="to/posterMD.xsl"/>
	<xsl:import href="to/boxcoverMD.xsl"/>
	<xsl:import href="to/commonMD.xsl"/>
	<xsl:import href="to/mediaMD.xsl"/>
	<xsl:import href="to/imageMD.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:variable name="Offer" select="/ADI3/Asset[@xsi:type='offer:OfferType']"/>
	<xsl:variable name="Terms" select="/ADI3/Asset[@xsi:type='terms:TermsType']"/>
	<xsl:variable name="Category" select="/ADI3/Asset[@xsi:type='offer:CategoryType']"/>
	<xsl:variable name="Title" select="/ADI3/Asset[@xsi:type='title:TitleType']"/>
	<xsl:variable name="Movie" select="/ADI3/Asset[@xsi:type='content:MovieType']"/>
	<xsl:variable name="Preview" select="/ADI3/Asset[@xsi:type='content:PreviewType']"/>
	<xsl:variable name="Poster" select="/ADI3/Asset[@xsi:type='content:PosterType']"/>
	<xsl:variable name="BoxCover" select="/ADI3/Asset[@xsi:type='content:BoxCoverType']"/>
	
	<xsl:template match="/">
		<ECMFSpec formatVersion="2.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
			<Package>
				<Title>
					<Fields>
						<xsl:apply-templates select="/ADI3/Asset[@xsi:type='terms:TermsType']" />
						<xsl:apply-templates select="/ADI3/Asset[@xsi:type='title:TitleType']" />
						<xsl:if test="/ADI3/Asset[@xsi:type='offer:CategoryType']">
							<Categories>
								<xsl:apply-templates select="/ADI3/Asset[@xsi:type='offer:CategoryType']" />
							</Categories>
						</xsl:if>
					</Fields>
				</Title>
				<xsl:apply-templates select="/ADI3/Asset[@xsi:type='content:MovieType']" />
				<xsl:apply-templates select="/ADI3/Asset[@xsi:type='content:PreviewType']" />
				<xsl:apply-templates select="/ADI3/Asset[@xsi:type='content:PosterType']" />
				<xsl:apply-templates select="/ADI3/Asset[@xsi:type='content:BoxCoverType']" />
				<Fields>
					<xsl:apply-templates select="/ADI3/Asset[@xsi:type='offer:OfferType']" />
				</Fields>
			</Package>
		</ECMFSpec>
	</xsl:template>
</xsl:stylesheet>