<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema"  xmlns:xs="http://www.w3.org/2001/XMLSchema"
 version="1.0">
	<xsl:import href="to/idMetadata.xsl"/>
	<xsl:import href="to/commonMetadata.xsl"/>
	<xsl:import href="to/additionalInfoMetadata.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="metadata" mode="asset_metadata">
		<xsl:apply-templates select="*" mode="id_metadata"/>
		<xsl:if test="rating">
			<xsl:element name="tns:Rating">
				<xsl:apply-templates mode="rating_metadata" select="rating"/>
			</xsl:element>
		</xsl:if>
		<xsl:apply-templates mode="common_metadata" select="*"/>
		<xsl:if test="screenFormat or streamFormat or HD or trickModesRestricted">
			<xsl:element name="tns:Video">
				<xsl:apply-templates select="screenFormat" mode="video_metadata"/>
				<xsl:apply-templates select="streamFormat" mode="video_metadata"/>
				<xsl:apply-templates select="HD" mode="video_metadata"/>
				<xsl:if test="count(trickModesRestricted) &gt; 0">
					<xsl:for-each select="trickModesRestricted">
						<xsl:element name="tns:TrickModesRestricted">
							<xsl:value-of select="."/>
						</xsl:element>
					</xsl:for-each>
				</xsl:if>
			</xsl:element>
		</xsl:if>
		<xsl:if test="count(language_iso639) &gt; 0">
			<xsl:for-each select="language_iso639">
				<xsl:element name="tns:Language">
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="count(audio) &gt; 0">
			<xsl:for-each select="audio">
				<xsl:element name="tns:Audio">
					<xsl:element name="tns:Type">
						<xsl:value-of select="."/>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="count(subtitleLanguage_iso639) &gt; 0">
			<xsl:for-each select="subtitleLanguage_iso639">
				<xsl:element name="tns:SubTitleLanguage">
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="count(dubbedLanguage_iso639) &gt; 0">
			<xsl:for-each select="dubbedLanguage_iso639">
				<xsl:element name="tns:DubbedLanguage">
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="macrovisionLevel or cgmsaLevel or disableHDCP">
			<xsl:element name="tns:Copyright">
				<xsl:apply-templates select="*" mode="copyright_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="providerId">
			<xsl:element name="tns:ProviderInfo">
				<xsl:apply-templates select="*" mode="provider_info_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="description or description/@language">
			<xsl:element name="tns:Description">
				<xsl:apply-templates select="*" mode="description_optional"/>
			</xsl:element>
		</xsl:if>
        <xsl:if test="additionalInfo">
            <xsl:element name="tns:CustomFields">
                <xsl:apply-templates select="additionalInfo" mode="additional_metadata"/>	        
            </xsl:element>		
        </xsl:if>
		<xsl:apply-templates select="*" mode="asset_metadata"/>
	</xsl:template>
	<xsl:template match="resolution" mode="asset_metadata">
		<xsl:element name="tns:Size">
			<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="PD" mode="asset_metadata">
		<xsl:element name="tns:PD">
			<xsl:choose>
				<xsl:when test=". = '1'">true</xsl:when>
				<xsl:when test=". = '0'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="runTimeSeconds" mode="asset_metadata">
		<xsl:element name="tns:Duration">
			<xsl:element name="tns:Duration"> 
				<xsl:variable name="seconds" select="number(.) mod 60"/>
				<xsl:variable name="minutes" select="(number(.) - $seconds) div 60"/>
				<xsl:variable name="hours" select="(number(.) - ($minutes * 60) - $seconds) div 3600"/>
				<xsl:choose>
					<xsl:when test="not(string(.) castable as xs:integer) or number(.) &lt; 0  ">
						<xsl:value-of select="."/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$seconds &lt; 10">
								<xsl:choose>
								<xsl:when test="$hours &lt; 10">
									<xsl:choose>
										<xsl:when test="$minutes &lt; 10">
											<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), concat('0', $minutes)), concat(':0', $seconds))"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), $minutes), concat(':0', $seconds))"/>
										</xsl:otherwise>
									</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$minutes &lt; 10">
												<xsl:value-of select="concat(concat(concat($hours, ':'), concat('0', $minutes)), concat(':0', $seconds))"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="concat(concat(concat($hours, ':'), $minutes), concat(':0', $seconds))"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
								<xsl:when test="$hours &lt; 10">
									<xsl:choose>
										<xsl:when test="$minutes &lt; 10">
											<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), concat('0', $minutes)), concat(':', $seconds))"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), $minutes), concat(':', $seconds))"/>
										</xsl:otherwise>
									</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$minutes &lt; 10">
												<xsl:value-of select="concat(concat(concat($hours, ':'), concat('0', $minutes)), concat(':', $seconds))"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="concat(concat(concat($hours, ':'), $minutes), concat(':', $seconds))"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="policyProfileId" mode="asset_metadata">
		<xsl:element name="tns:PolicyProfileId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="deviceRestrictionProfileId" mode="asset_metadata">
		<xsl:element name="tns:DeviceRestrictionProfileId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="screenFormat" mode="video_metadata">
		<xsl:element name="tns:ScreenFormat">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="streamFormat" mode="video_metadata">
		<xsl:element name="tns:StreamFormat">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="HD" mode="video_metadata">
		<xsl:element name="tns:HDContent">
			<xsl:choose>
				<xsl:when test=". = '1'">true</xsl:when>
				<xsl:when test=". = '0'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="asset_metadata"/>
	<!-- provider info optional -->
	<xsl:template match="providerID" mode="provider_info_optional">
		<xsl:if test=".">
			<xsl:element name="tns:Identifier">
				<xsl:element name="tns:Id">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*" mode="provider_info_optional"/>
	<!-- end -->
	<!-- description optional -->
	<xsl:template match="description" mode="description_optional">
		<xsl:if test=".">
			<xsl:if test="@language">
				<xsl:element name="tns:Language">
					<xsl:attribute name="value">
						<xsl:value-of select="@language"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:if>
			<xsl:element name="tns:Text">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*" mode="description_optional"/>
	<!-- end -->
</xsl:stylesheet>
