import os
import sys
import shutil
import subprocess
import fnmatch
import glob
import shutil

from Common import Common

HOME_DIR = "/"
NO_REPLACE_DIRS = ["/opt/tandbergtv/cms/workflow/plugins/subsystems/**/resources/properties"]
RECORDED_FILE_LIST_DIR = "/opt/tandbergtv/cms/conf/prepack/deploy-files/"
DEPLOY_FILE_LIST_DIR = "/mnt/cms-prepack/installer/deploy-files/"
UPGRADE_FROM_60_SCRIPT = "/mnt/cms-prepack/installer/upgrade/upgrade_from_60.sh"
TEMPALTE_FILE_EXTENSION = ".par"
TEMPALTE_FILE_PATH = "/opt/tandbergtv/cms/workflow/templates/*"

class DeployFileHelper:

    @staticmethod
    def deployRpmFiles(isFresh, rpm_files, no_replace_file_tuple):
        if not rpm_files:
            return
        if isFresh:  # Fresh install: copy files directly
            for rpm_file in rpm_files:
                print "[INFO] Syncing files in {}".format(rpm_file)
                subprocess.call(['rsync', '-rK', os.path.abspath(rpm_file) + "/", HOME_DIR])
            subprocess.call("rm -rf " + TEMPALTE_FILE_PATH, shell=True)
        else:  # Upgrade: copy files that are not "noreplace"
            for rpm_file in rpm_files:
                DeployFileHelper.__upgrade_rpm_files(rpm_file, no_replace_file_tuple)

    @staticmethod
    def get_no_replace_files(no_replace_files):
        no_replace_files.extend(NO_REPLACE_DIRS)
        no_replace_file_list = []
        for no_replace_file_dir in no_replace_files:
            no_replace_file_list.extend(glob.glob(no_replace_file_dir))
        # remove duplicates
        no_replace_file_list = set(no_replace_file_list)
        print '[INFO] noreplace files list:\n', '\n'.join(str(f) for f in no_replace_file_list)
        return tuple(no_replace_file_list)

    @staticmethod
    def record_deployed_files():
        if not os.path.isdir(RECORDED_FILE_LIST_DIR):
            os.mkdir(RECORDED_FILE_LIST_DIR)

        deploy_file_list_path = os.listdir(DEPLOY_FILE_LIST_DIR)
        for file_path in deploy_file_list_path:
            subprocess.call(['cp', DEPLOY_FILE_LIST_DIR + file_path, RECORDED_FILE_LIST_DIR])
            print "[INFO] Save recording file %(recordFile)s to %(target)s" % \
                {'recordFile': DEPLOY_FILE_LIST_DIR + file_path, 'target': RECORDED_FILE_LIST_DIR}

    @staticmethod
    def remove_deployed_files_with_exclude(exclude_file_list):
        recorded_file_paths = DeployFileHelper.__collect_files_to_remove()
        if recorded_file_paths:
            # remove file recorded in `RECORDED_FILE_LIST_DIR` and really exits and isn't no-replace file
            for recorded_file_path in recorded_file_paths:
                with open(recorded_file_path) as f:
                    for file_to_remove in f:
                        file_to_remove = file_to_remove.strip()
                        if os.path.exists(file_to_remove) and not file_to_remove.startswith(exclude_file_list):
                            print "[INFO] removing file %s" % file_to_remove
                            os.remove(file_to_remove)
                # remove the recording file
                os.remove(recorded_file_path)
        elif os.path.isfile(UPGRADE_FROM_60_SCRIPT):
            # support upgrade from 6.0
            Common.executeScripts([UPGRADE_FROM_60_SCRIPT])
        else:
            print "[ERROR] Deployed files list was empty!"
            sys.exit(1)

    @staticmethod
    def __collect_files_to_remove():
        # collect recorded file list in `RECORDED_FILE_LIST_DIR`
        recorded_file_paths = []
        if os.path.exists(RECORDED_FILE_LIST_DIR):
            recorded_file_list_arr = os.listdir(RECORDED_FILE_LIST_DIR)
            for recorded_file_list in recorded_file_list_arr:
                recorded_file_path = RECORDED_FILE_LIST_DIR + recorded_file_list
                if os.path.isdir(recorded_file_path):
                    print "[INFO] %s is a folder" % recorded_file_path
                    continue
                recorded_file_paths.append(recorded_file_path)
        return recorded_file_paths

    @staticmethod
    def __upgrade_rpm_files(f, no_replace_file_tuple):
        print "[INFO] Upgrade: copying files from source: {}.".format(f)
        for path, dirs, files in os.walk(os.path.abspath(f)):
            DeployFileHelper.__create_dir_if_not_exist(f, dirs, path)
            for file_name in files:
                file_path = os.path.join(path, file_name)
                target_file = DeployFileHelper.getTargetFilePath(f, file_path)
                if file_path.endswith(TEMPALTE_FILE_EXTENSION):
                    continue
                if not target_file.startswith(no_replace_file_tuple) or not os.path.exists(target_file):
                    shutil.copyfile(file_path, target_file)

    #############################################################################################################
    # deploy those conf/ files
    #############################################################################################################

    @staticmethod
    def deployConfFiles(isFresh, config_file_directories):
        if config_file_directories:
            for configFileDir in config_file_directories:
                DeployFileHelper.copy_conf_files(isFresh, configFileDir)

    @staticmethod
    def copy_conf_files(isFresh, directory):
        print "[INFO] Copying all config files from directory {}".format(directory)
        for path, dirs, files in os.walk(os.path.abspath(directory)):
            # deal with subdirectories under dir "path"
            DeployFileHelper.__create_dir_if_not_exist(directory, dirs, path)
            # deal with all files under dir "path"
            for filename in fnmatch.filter(files, "*"):
                filepath = os.path.join(path, filename)
                # get destination full file path
                final_filepath = DeployFileHelper.getTargetFilePath(directory, filepath)
                if isFresh or not os.path.exists(final_filepath):
                    # PrePack fresh installation: move the file directly
                    # PrePack upgrade: move the file if target file is not exist
                    shutil.copyfile(filepath, final_filepath)

    @staticmethod
    def getTargetFilePath(directory, filepath):
        return HOME_DIR + filepath[filepath.index(directory) + len(directory):]

    @staticmethod
    def chown(user, group, path, recursive=False):
        os.popen("chown %s%s:%s %s" % (
            ["", "-R "][recursive], user, group, path.replace("(", "\(").replace(")", "\)").replace(" ", "\ ").replace("$", "\$")))

    @staticmethod
    def deleteFile(filePath):
        if os.path.exists(filePath):
            os.remove(filePath)

    @staticmethod
    def __create_dir_if_not_exist(directory, dirs, path):
        for sub_dir in dirs:
            dir_path = os.path.join(path, sub_dir)
            save_dir_path = DeployFileHelper.getTargetFilePath(directory, dir_path)
            if os.path.exists(save_dir_path):  # Skip if directory already exists
                continue
            print "- Creating directory: {}".format(save_dir_path)
            os.mkdir(save_dir_path)

