import os
import sys
import base64
from K8sUtil import *
from KubernetesConstants import *


class DeploySecretsHelper:
	
	@staticmethod
	def deployFromJson(secret_json_array):
		if not secret_json_array:
			return
		success, exist_secret_keys = K8sUtil.getData(SECRET, EXTERNAL_CREDENTAIL_SECRET)
		if not success:
			print "[ERROR] Fetching existing secret key from %s failure, exit installation" % EXTERNAL_CREDENTAIL_SECRET
			sys.exit(1)
		
		for secret_json in secret_json_array:
			
			if secret_json["key"] in exist_secret_keys:
				continue
			
			success = K8sUtil.patch(SECRET, EXTERNAL_CREDENTAIL_SECRET, secret_json["key"], base64.b64encode(secret_json["value"]))
			if not success:
				print "[ERROR] Adding certificate %(key)s with value $(value)s to secret %(secret)s failure, exit installation" \
					% {'key': secret_json["key"], 'value': secret_json["value"], 'secret': EXTERNAL_CREDENTAIL_SECRET}
				sys.exit(1)
