import os
import sys
from HttpRequestDecorator import HttpRequestDecorator
import json
import time
import shutil
import glob

WORKFLOW_TEMPLATES_PATH = "/opt/tandbergtv/cms/workflow/templates"
WORKFLOW_TEMPLATE_PATH_REJECTED = "/opt/tandbergtv/cms/workflow/rejected"
WORKFLOW_TEMPLATE_PATH_IMPORTED = "/opt/tandbergtv/cms/workflow/imported"
ORIGINAL_TEMPLATES_PATH = "/mnt/cms-prepack/installer/templates-par/"
SEP_SLASH = "/"


class DeployTemplatesHelper:
	
	@staticmethod
	def deployTemplates():
		os.system("cp %s %s" % (ORIGINAL_TEMPLATES_PATH + "*", WORKFLOW_TEMPLATES_PATH))
	
	@staticmethod
	def getTemplatesToInstall():
		return os.listdir(ORIGINAL_TEMPLATES_PATH)
	
	
	@staticmethod
	def waitForAllTemplatesIngested(templatesToIngest, interval=10, timeout=500):
		totalTemplatesCount = len(templatesToIngest)
		if totalTemplatesCount > 0:
			print("Ingesting templates...")
			print totalTemplatesCount, "templates are not ready, waiting..."
		
		timeToWait = timeout
		processedTemplates = []
		while len(processedTemplates) != totalTemplatesCount and timeToWait > 0:
			processedTemplates = []
			for template in templatesToIngest:
				templateName = template[template.rfind(SEP_SLASH) + 1:(len(template) - 4)]
				templatePath = WORKFLOW_TEMPLATES_PATH + os.sep + templateName + ".par"
				if not os.path.exists(templatePath):
					processedTemplates.append(template)
					continue
				templatePath = WORKFLOW_TEMPLATE_PATH_IMPORTED + os.sep + templateName + "*.par"
				for importName in glob.glob(templatePath):
					processedTemplates.append(template)
					break
			
			print 'Ingesting templates:', len(processedTemplates), SEP_SLASH, totalTemplatesCount
			time.sleep(interval)
			timeToWait = timeToWait - interval
		
		if len(processedTemplates) == totalTemplatesCount:
			templatesToIngestDic = DeployTemplatesHelper.__getTemplatesNameVersion(templatesToIngest)
			mismatchTemplates = DeployTemplatesHelper.__getFinalMismatchedTemplates(templatesToIngestDic)
			if len(mismatchTemplates) == 0:
				print "All templates are ready now."
			else:
				print "[ERROR] Templates below are not ingested:"
				for tName, tVersion in mismatchTemplates.items():
					print "[ERROR] template Name:", tName, ", expected version:", tVersion
				sys.exit(2)
		else:
			print '[ERROR] These templates still cannot be ingested after a long time, please check /opt/tandbergtv/cms/workflow/templates.', (set(templatesToIngest) - set(processedTemplates))
			sys.exit(2)
	
	
	@staticmethod
	def __getTemplatesNameVersion(templates):
		templatesDic = {}
		if len(templates) > 0:
			for t in templates:
				values = t.rsplit("-v", 1)
				tName = values[0]
				tVersion = values[1]
				last_index = tName.rfind(SEP_SLASH)
				if last_index >= 0:
					tName = tName[last_index+1:]
				last_index = tVersion.rfind(".")
				if last_index >= 0:
					tVersion = tVersion[0:last_index]
				templatesDic[tName] = tVersion
		return templatesDic
	
	"""
	as workflow can respond at most 100 records for one request,
	 so need to request multiple times to get all the templates
	"""
	@staticmethod
	def __getAllTemplates():
		templates = []
		requestUrl = "https://app:8443/workflow/templates?count=500&start=0"
		header = {'X-API-Version': '1'}
		while True:
			print "requestUrl=" + requestUrl
			resp = HttpRequestDecorator.request(requestUrl, "GET", None, header)
			if resp[0]["status"] != '200':
				print "status" + resp[0]["status"]
				print "[ERROR] Failed to get templates due to:", resp
				sys.exit(2)
			respPayload = json.loads(resp[1])
			if respPayload["templates"] == "":
				print "No Template found!"
				break
			templates = templates + respPayload["templates"]
			if respPayload.has_key("next"):
				requestUrl = respPayload["next"]
			else:
				break
		return templates
	
	@staticmethod
	def __getCurrentMismatchedTemplates(templatesToIngestDic):
		mismatchTemplates = {}
		allTemplates = []
		# for CMS5.x, it needs more time to load the templates to CMS GUI after restarting cms and workflow
		for x in range(0, 10):
			allTemplates = DeployTemplatesHelper.__getAllTemplates()
			if len(allTemplates) > 0:
				break
			print 'Waiting 30 seconds for templates to load to CMS...'
			time.sleep(30)
		
		if len(allTemplates) == 0:
			print "[ERROR] No Template is found in CMS."
			sys.exit(2)
		
		for tName, tVersion in templatesToIngestDic.items():
			foundFlag = False
			for template in allTemplates:
				if template["name"] == tName and int(template["version"]) >= int(tVersion):
					if int(template["version"]) > int(tVersion):
						print 'Template name:' + template["name"] + ', current version:' + str(template["version"]) + ',is higher than the ingesting template(%s-v%s)...' % (tName, str(tVersion))
					foundFlag = True
					break
			if not foundFlag:
				mismatchTemplates[tName] = tVersion
		return mismatchTemplates
	
	@staticmethod
	def __retryIngestMismatchedTemplates(mismatchTemplates):
		for tName, tVersion in mismatchTemplates.items():
			rejectedTemplatePath = WORKFLOW_TEMPLATE_PATH_REJECTED + os.sep + tName + "-v" + str(tVersion) + "*.par"
			matchedTemplatePath = glob.glob(rejectedTemplatePath)
			if len(matchedTemplatePath):
				print '[INFO] Re-ingesting template(%s-v%s) from /rejected directory...' % (tName, str(tVersion))
				parName = tName + "-v" + str(tVersion) + ".par"
				templateNewPath = WORKFLOW_TEMPLATE_PATH_REJECTED + os.sep + parName
				# rename the template par file under ./rejected to remove the timestamp
				os.rename(matchedTemplatePath[0], templateNewPath)
				shutil.copyfile(templateNewPath, WORKFLOW_TEMPLATES_PATH + os.sep + parName)
				os.remove(templateNewPath)
	
	@staticmethod
	def __getFinalMismatchedTemplates(templatesToIngestDic, interval=15, timeout=300):
		timeToWait = timeout
		mismatchTemplates = {}
		while timeToWait > 0:
			mismatchTemplates = DeployTemplatesHelper.__getCurrentMismatchedTemplates(templatesToIngestDic)
			if len(mismatchTemplates) == 0:
				templatesToIngestDic = {}
				break
			else:
				DeployTemplatesHelper.__retryIngestMismatchedTemplates(mismatchTemplates)
				templatesToIngestDic = mismatchTemplates
				
				print 'Waiting %s seconds for templates%s to be ingested to CMS...' % (str(interval), templatesToIngestDic)
				time.sleep(interval)
				timeToWait = timeToWait - interval
		
		mismatchTemplates = templatesToIngestDic
		return mismatchTemplates


if __name__ == '__main__':
	DeployTemplatesHelper.deployTemplates()
	templatesToInstall = DeployTemplatesHelper.getTemplatesToInstall()
	
	# Wait for CMS workflow to ingest adaptors and templates
	DeployTemplatesHelper.waitForAllTemplatesIngested(templatesToInstall)