#!/usr/bin/env python
import BaseClass
import json
from HttpRequestDecorator import HttpRequestDecorator
import urllib


class ResourcesRestMgr(BaseClass.BaseHandler):
	RESOURCE_SERVICE_LOCATION = "https://app:8443/workflow/resources"
	
	def convertStatus(self, statusCode):
		switcher = {
			1: "Initializing",
			2: "Online",
			3: "Offline",
			4: "Initialization Error",
			5: "HeartBeat Error",
			6: "Error",
			7: "Inactive",
			8: "Invalid",
		}
		return switcher.get(statusCode, "Online")
	
	def __init__(self):
		BaseClass.BaseHandler.__init__(self)
		self.header = {'X-API-Version': '1'}
		print "ResourcesRestMgr is initializing..."
	
	# Return resource id
	def checkExistence(self, data):
		resourceName = data[0]
		resp = self.getResourceByName(resourceName)
		
		if resp[0]["status"] != '200':
			return False
		return json.loads(resp[1]).get("id", "")
	
	def getResourceByName(self, resourceName):
		getResourceByNameUrl = ResourcesRestMgr.RESOURCE_SERVICE_LOCATION + "/name/" + urllib.quote(resourceName)
		return HttpRequestDecorator.request(getResourceByNameUrl, "GET", None, headers=self.header)
	
	# data[0]     NAME
	# data[1]     RESOURCETYPENAME
	# data[2]     RESOURCEGROUPNAME
	# data[3]     CONNECTIONSTRING
	# data[4]     MAXCONCURRENTUSERS,
	# data[5]     ADMINISTRATIVERESOURCESTATUSID
	# data[6]     OPERATIONALRESOURCESTATUSID,
	# data[7]     HEARTBEATCONNECTIONSTRING,
	# data[8]     HEARTBEATFREQUENCY,
	# data[9]     ISACTIVE,
	# data[10]    IGNORETIMEOUT,
	# data[11]    USER_NAME,
	# data[12]    FUNCTIONALTYPE
	def buildResBody(self, resourceRecord):
		resourceBody = {}
		resourceBody["resourceTypeName"] = resourceRecord[1]
		resourceBody["functionalType"] = resourceRecord[12]
		resourceBody["adminState"] = self.convertStatus(resourceRecord[5])
		resourceBody["name"] = resourceRecord[0]
		resourceBody["connectionString"] = resourceRecord[3]
		resourceBody["heartbeatConnectionString"] = resourceRecord[7]
		resourceBody["heartbeatFrequency"] = resourceRecord[8]
		resourceBody["maxConcurrentUsage"] = resourceRecord[4]
		resourceBody["ignoreTimeout"] = resourceRecord[10]
		resourceBody["resourceGroups"] = []
		
		for resGroup in resourceRecord[2]:
			resourceBody["resourceGroups"].append({"name": resGroup})
		body = json.dumps(resourceBody)
		return body
	
	def insert(self, id_, resourceRecord):
		body = self.buildResBody(resourceRecord)
		print "Insert Resource: " + str(body)
		
		resp = HttpRequestDecorator.request(ResourcesRestMgr.RESOURCE_SERVICE_LOCATION, "POST", body, headers=self.header)
		if resp[0]["status"] != '200':
			print "[ERROR]", resp
			return False
		return True
	
	# resourceRecord[0]     NAME
	def update(self, resourceRecord):
		resourceId = self.checkExistence(resourceRecord)
		if resourceId == False:
			print "update: the resource '%s' is not existed!" % resourceRecord[0]
			return False
		
		if self.makeResourceOffline(resourceId) == False:
			print "update: make resource '%s' offline Fail!" % resourceRecord[0]
			return False
		
		requestUrl = ResourcesRestMgr.RESOURCE_SERVICE_LOCATION + "/" + str(resourceId)
		print "update Resource by Url: " + requestUrl
		
		body = self.buildResBody(resourceRecord)
		print "Update Resource: " + str(body)
		
		resp = HttpRequestDecorator.request(requestUrl, "PUT", body, headers=self.header)
		if resp[0]["status"] != '200':
			print resp
			return False
		
		return self.makeResourceOnline(resourceId)
	
	# data[0] : resource name
	def delete(self, data):
		resourceId = self.checkExistence(data)
		if resourceId == False:
			print "delete: the resource '%s' is not existed!" % data[0]
			return True
		
		if self.makeResourceOffline(resourceId) == False:
			print "delete: make resource '%s' offline Fail!" % data[0]
			return False
		
		requestUrl = ResourcesRestMgr.RESOURCE_SERVICE_LOCATION + "/" + str(resourceId)
		print "deleting resource by Url: " + requestUrl
		resp = HttpRequestDecorator.request(requestUrl, "DELETE", None, headers=self.header)
		
		if resp[0]["status"] != '200':
			print resp
			return False
		return True
	
	# args[0] : resource name
	def backUpExisting(self, args):
		resp = self.getResourceByName(args[0])
		if resp[0]["status"] != '200':
			print resp
			return False
		
		respPayload = json.loads(resp[1])
		resourceGroups = []
		for resourceGroup in respPayload.get("resourceGroups"):
			resourceGroups.append(resourceGroup.get("name"))
		
		result = list([respPayload.get("name"), respPayload.get("resourceTypeName")]) + [resourceGroups] + list(
			[respPayload.get("connectionString"), respPayload.get("maxConcurrentUsage"),
			 respPayload.get("heartbeatConnectionString"), respPayload.get("heartbeatFrequency"),
			 respPayload.get("userName")])
		print "backUpExisting: " + str(result)
		return result
	
	def getNextId(self):
		return None
	
	def makeResourceOnline(self, resourceId):
		onlineUrl = ResourcesRestMgr.RESOURCE_SERVICE_LOCATION + "/actions/online?id=" + str(resourceId)
		print "onlineUrl: " + onlineUrl
		resp = HttpRequestDecorator.request(onlineUrl, "PUT", None, headers=self.header)
		
		if resp[0]["status"] != '200':
			print resp
			return False
		return True
	
	def makeResourceOffline(self, resourceId):
		offlineUrl = ResourcesRestMgr.RESOURCE_SERVICE_LOCATION + "/actions/offline?id=" + str(resourceId)
		print "offlineUrl: " + offlineUrl
		resp = HttpRequestDecorator.request(offlineUrl, "PUT", None, headers=self.header)
		
		if resp[0]["status"] != '200':
			print resp
			return False
		return True
