#!/usr/bin/env python
import re
import os
import tempfile


class PropertiesUtils:
    
    def __init__(self, filePath):
        self.file_name = filePath
        self.properties = {}
        try:
            fopen = open(self.file_name, 'r')
            for line in fopen:
                line = line.strip()
                if line.find('=') > 0 and not line.startswith('#'):
                    strs = line.split('=')
                    self.properties[strs[0].strip()] = strs[1].strip()
        except Exception, e:
            print 'parse properties file error'
        else:
            fopen.close()

    def has_key(self, key):
        return self.properties.has_key(key)

    def get(self, key, default_value=''):
        if self.properties.has_key(key):
            return self.properties[key]
        return default_value


def writeFile(filePath, from_regex, to_str):
    with open(filePath) as f:
        origi_file = f.read()
        origi_file = re.sub(from_regex, to_str, origi_file)
        
    with open(filePath, "w") as f:
        f.write(origi_file) 
