#!/bin/bash

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
QC_PROFILE_PATH="/opt/tandbergtv/cms/conf/workflow/preferences/profiles/qc.xml"

batonQC='<profile name="baton-qc">
		<template>Baton QC</template>
		<ContentLocation>\\10.252.6.81\ifs\AdaptationsShare229</ContentLocation>
		<PathSubstring>8</PathSubstring>
		<report.enable>true</report.enable>
		<report.url.prefix>http://localhost:8081/baton-reports</report.url.prefix>
		<report.symbolic.link.name>baton_report</report.symbolic.link.name>
	</profile>'
	
if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${QC_PROFILE_PATH} ]; then

  if egrep '<profile\s+name="baton-qc">' "${QC_PROFILE_PATH}" >/dev/null 2>&1; then
    echo \"baton-qc\" profile already exists.
  else
    python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${QC_PROFILE_PATH} -k /profiles -v "$batonQC"
  fi
fi	