#!/usr/bin/env python
import BaseClass
import CustomFieldsGroups

from xml.dom.minidom import parseString
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy

class CustomFields(BaseClass.BaseClass):
#	fieldTypes = {
#		1 : "string",
#		2 : "boolean"
#	}

	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "NAME, GROUP_NAME, ASSET_PATH, DATA_TYPE, JOB_PARAMETER, JOB_SCHEDULE_PARAMETER, DISPLAY_NAME, MULTIVALUE, FIELD_TYPE"
	
		self.selectStatement = "SELECT CF.NAME, CFG.DISPLAY_NAME AS GROUP_NAME, CFG.ASSET_PATH, CF.DATA_TYPE, CF.JOB_PARAMETER, "\
			"CF.JOB_SCHEDULE_PARAMETER, CF.DISPLAY_NAME, CF.MULTIVALUE, CF.FIELD_TYPE "\
			"FROM MDM_CUSTOM_FIELD CF "\
  			"JOIN MDM_CUSTOM_FIELD_GROUP CFG "\
     		"ON (CF.GROUP_ID = CFG.GROUP_ID)"
	
	def checkExistence(self, data):
		fieldName = data[0]
		self.groupId = self.getGroupId(data[1], data[2])
		if self.groupId == False:
			return False
		self.cursor.execute("SELECT CUSTOM_FIELD_ID FROM MDM_CUSTOM_FIELD WHERE NAME='%s' AND GROUP_ID=%s" % (fieldName, self.groupId))
		if len(self.cursor.fetchall()):
			return True
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT nextval('mdm_custom_field_seq')")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO MDM_CUSTOM_FIELD (CUSTOM_FIELD_ID, NAME, GROUP_ID, DATA_TYPE, JOB_PARAMETER, JOB_SCHEDULE_PARAMETER, " \
			            "DISPLAY_NAME, MULTIVALUE, FIELD_TYPE) VALUES %s" % self.tupleToStr([id_, data[0], self.groupId] + list(data[3:]))
			print statement
			self.cursor.execute(statement)

			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
	
	def update(self, data):
		try:
			statement = "UPDATE MDM_CUSTOM_FIELD SET DATA_TYPE='%s', JOB_PARAMETER='%s', JOB_SCHEDULE_PARAMETER='%s', " \
			            "DISPLAY_NAME='%s', MULTIVALUE='%s', FIELD_TYPE='%s' WHERE NAME='%s' AND GROUP_ID=%s" % (data[3], data[4], data[5], data[6], data[7], data[8], data[0], self.groupId)
			print statement
			self.cursor.execute(statement)

			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def delete(self, data):
		"""Delete custom fields if exists. Only work for CMS3.0 or higher
		data[0]: fieldName
		data[1]: groupName
		data[2]: assetPath
		"""
		if self.checkExistence(data):
			try:
				fieldName = data[0]
				statement = "SELECT CUSTOM_FIELD_ID FROM MDM_CUSTOM_FIELD WHERE NAME='%s' AND GROUP_ID='%s' " % (fieldName, self.groupId)
				print statement
				self.cursor.execute(statement)
			
				row = self.cursor.fetchall()
				if len(row)==1:
					fieldId = row[0][0]
					statement = "DELETE FROM MDM_CUSTOM_FIELD WHERE CUSTOM_FIELD_ID='%s'" % fieldId
					print statement
					self.cursor.execute(statement)
				return self.commit()
			except Exception, e:
				print e
				return self.rollback()
					
	def getGroupId(self, *data):
		"""getGroupId(groupName, assetPath)"""
		return CustomFieldsGroups.CustomFieldsGroups().checkExistence(data)
	
	def getCustomFields(self):
		"""select cf.name, cfg.display_name as GROUP_NAME, cfg.asset_path, cf.data_type, cf.job_parameter, cf.JOB_SCHEDULE_PARAMETER, cf.display_name, cf.multivalue, cf.field_type
		from mdm_custom_field cf
		join mdm_custom_field_group cfg
  			on (cf.group_id = cfg.group_id)"""
  	

	def backUpExisting(self, args):
		"""
		args[0]: NAME
		args[1]: DISPLAY_NAME
		args[2]: ASSET_PATH
		"""
		#"NAME", "DATA_TYPE", "JOB_PARAMETER", "JOB_SCHEDULE_PARAMETER", "DISPLAY_NAME", "MULTIVALUE", "FIELD_TYPE"
		statement = "SELECT NAME, DATA_TYPE, JOB_PARAMETER, JOB_SCHEDULE_PARAMETER, DISPLAY_NAME, MULTIVALUE, FIELD_TYPE "\
			" FROM MDM_CUSTOM_FIELD WHERE NAME='%s'AND GROUP_ID=%s" # % (fieldName, self.groupId)
		if len(args) >= 3:
			if self.checkExistence(args):
				self.cursor.execute(statement % (args[0], self.groupId))
				rows = self.cursor.fetchall()
				return rows[0]
		else:
			print("CustomFields::backUpExisting:The number of parameters is not correct")
		return ""
	
	def backUpAllExisting(self, args):
		"""
		args[0]: DISPLAY_NAME	
		args[1]: ASSET_PATH
		"""
		items = []		
		fieldArray = ["NAME", "DATA_TYPE", "JOB_PARAMETER", "JOB_SCHEDULE_PARAMETER", "DISPLAY_NAME", "MULTIVALUE", "FIELD_TYPE"]			
		statement = "SELECT NAME, DATA_TYPE, JOB_PARAMETER, JOB_SCHEDULE_PARAMETER, DISPLAY_NAME, MULTIVALUE, FIELD_TYPE "\
		 	" FROM MDM_CUSTOM_FIELD WHERE GROUP_ID=%s"
		
		if len(args)>=2:
			customFieldGrp = CustomFieldsGroups.CustomFieldsGroups()
			groupId = customFieldGrp.checkExistence(args)
			self.cursor.execute(statement % groupId)
			rows = self.cursor.fetchall()
            
			for row in rows:
				if(len(row) == len(fieldArray)):
					customFieldObj = {}
					for i in range(0, len(fieldArray)):
						if row[i] == None:
							customFieldObj[fieldArray[i]] = ""
						else:
							customFieldObj[fieldArray[i]] = row[i]
					items.append(customFieldObj)
		return items

		

def main():
	cf = CustomFields()
	cf.delete("Encryption_Required", "Custom Fields", "PACKAGE/TITLE")
	#cf.add(("TranscodeToTheMax", "Custom Fields", "PACKAGE/ENCRYPTED", "String", "N", "N", "Test Script Field", "N", 1))
	#cf.export("/tmp/cf.tdf")
	
if __name__ == "__main__":
	main()
