import json
from HttpRequestDecorator import HttpRequestDecorator


class FilemanagerRestMgr:
	FILEMANAGER_SERVICE_LOCATION = "https://app:8443/cms/services/settings"
	
	def __init__(self):
		self.header = {'Accept': 'application/json', 'Content-Type': 'application/json'}
		print "FilemanagerRestMgr is initializing..."
	
	def updateDeleteFileFilterRegex(self, regex):
		safeDeleteFileFilterURI = FilemanagerRestMgr.FILEMANAGER_SERVICE_LOCATION + "/com.ericsson.cms.filemanager.delete"
	
		body = json.dumps({'safeDeleteFileFilterRegex': regex})
		print "Update safe delete file filter regex:", regex
	
		resp = HttpRequestDecorator.request(safeDeleteFileFilterURI, "PUT", body, self.header)
		if resp[0]["status"] != '200':
			print "[ERROR]", resp

	def getDeleteFileFilterRegex(self):
		safeDeleteFileFilterURI = FilemanagerRestMgr.FILEMANAGER_SERVICE_LOCATION + "/com.ericsson.cms.filemanager.delete"
		resp = HttpRequestDecorator.request(safeDeleteFileFilterURI, headers=self.header)
		if resp[0]["status"] != '200':
			print "[ERROR] Get delete file filter regex fail:", resp
			return False, ""
		
		return True, json.loads(resp[1]).get("safeDeleteFileFilterRegex", "")
