#!/usr/bin/env python
import BaseClass
import base64
import json
from HttpRequestDecorator import HttpRequestDecorator
import urllib
import SelectorKeys6X


class SelectorKeyRestMgr(BaseClass.BaseHandler):
    SELECTOR_KEY_LOCATION = "https://app:8443/workflow/templates/actions"
    ADD_KEY = "addkey"
    REMOVE_KEY = "removekey"
    SUB_ERROR_MSG = "Failed to find template for selector key"
        
    def __init__(self):
        BaseClass.BaseHandler.__init__(self)
        self.header = {'X-API-Version': '1'}
        self.selectorKeyService = SelectorKeys6X.SelectorKeys6X()
        print "SelectorKeyRestMgr is initializing..."
    
    def checkExistence(self, data):
        return self.selectorKeyService.checkExistence(data)
    
    def getNextId(self):
        return 1
        
    def insert(self, id_, data):
        requestUrl = self.SELECTOR_KEY_LOCATION + "/" + self.ADD_KEY + "?templateName="+ urllib.quote(data[1]) +"&selectorKey="+data[0]

        resp = HttpRequestDecorator.request(requestUrl, "PUT", None, headers=self.header)
        if resp[0]["status"] != '200':
            print resp
            return False
        print 'Insert SelectorKey '+data[0]+' Succeed!'
        return True

    def update(self, data):
        self.delete(data)
        self.insert(self.getNextId(), data)
    
    def delete(self, data):
        """delete the association between selector keys and template
        data[0]: selctor keynikd
        data[1]: template name
        """
        key = data[0]
        requestUrl = self.SELECTOR_KEY_LOCATION + "/" + self.REMOVE_KEY + "?selectorKey="+key
        resp = HttpRequestDecorator.request(requestUrl, "PUT", None, headers=self.header)
        """
        errorMsg.find(self.SUB_ERROR_MSG) means this key don't exists before.
        """
        errorMsg = ''
        if resp[1] is not None and resp[1].find("errors")>0:
            errorMsg = json.loads(resp[1])["errors"][0]["message"]
        if resp[0]["status"] != '200' and errorMsg.find(self.SUB_ERROR_MSG) == -1:
            print 'error:',resp
            return False
        if errorMsg.find(self.SUB_ERROR_MSG) > 0:
            print key + 'do not exists'
        print 'Delete SelectorKey '+key+' Succeed!'
        return True
 
    
    def backUpExisting(self, args):   
        print 'backup existing at selectorKeyRestMgr'     
        return self.selectorKeyService.backUpExisting(args)
    
def main():
    skMgr = SelectorKeyRestMgr()
    selectorKeys = ["1234","Target Title", None]
    skMgr.insert("1234", selectorKeys)

if __name__ == "__main__":
    main()

