#!/usr/bin/env python
import BaseClass

import uuid

from xml.dom.minidom import parseString
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy


class CustomFieldsGroups(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "DISPLAY_NAME, ASSET_PATH, UUID"
		self.table = "MDM_CUSTOM_FIELD_GROUP"
		
		self.setSelectStatement()
	
	
	def checkExistence(self, data):
		groupName = data[0]
		assetPath = data[1]
		self.cursor.execute("SELECT GROUP_ID FROM MDM_CUSTOM_FIELD_GROUP WHERE DISPLAY_NAME='%s' AND ASSET_PATH='%s'" % (groupName, assetPath))
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False

		
	def getNextId(self):
		self.cursor.execute("select nextval('mdm_custom_field_group_seq')")
		return self.cursor.fetchall()[0][0]

	def insert(self, id_, data):
		if len(data) == 3:
			u = data[2]
		else:
			u = self.generateUUID(data[0], data[1])
		try:
			statement = "INSERT INTO MDM_CUSTOM_FIELD_GROUP (GROUP_ID, DISPLAY_NAME, ASSET_PATH, UUID) VALUES %s" % self.tupleToStr([id_] + list(data[:2]) + [u])
			print statement
			self.cursor.execute(statement)

			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def update(self, data):
		if len(data) == 3:
			u = data[2]
			try:
				statement = "UPDATE MDM_CUSTOM_FIELD_GROUP SET UUID='%s' WHERE DISPLAY_NAME='%s' AND ASSET_PATH='%s'" % (u, data[0], data[1])
				print statement
				self.cursor.execute(statement)

				return self.commit()
			except Exception, e:
				print e
				return self.rollback()

	def delete(self, data):
		"""delete the custom field group from table 'MDM_CUSTOM_FIELD_GROUP'.
		if the custom field group has custom fields, all the custom fields under
		this group will be deleted as well.
		data[0]: display name
		data[1]: asset path
		
		for example, 
		delete('Custom Fields', 'PACKAGE/PREVIEW')
		"""
		groupName = data[0]
		assetPath = data[1]
		groupId = self.checkExistence(data)
		
		if groupId == False:
			return
		
		try:
			# Delete all the custom fields under this group
			statement = "DELETE FROM MDM_CUSTOM_FIELD WHERE GROUP_ID = '%s'" % groupId
			print statement 
			self.cursor.execute(statement)
			
			# Delete the custom field group
			statement = "DELETE FROM MDM_CUSTOM_FIELD_GROUP WHERE GROUP_ID = '%s'" % groupId
			print statement 
			self.cursor.execute(statement)
					
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
			
	def generateUUID(self, *data):
		return str(uuid.uuid5(uuid.NAMESPACE_DNS, str(data)))
	
	#args[0]: DISPLAY_NAME
	#args[1]: ASSET_PATH
	def backUpExisting(self, args):
		statement ="SELECT DISPLAY_NAME, ASSET_PATH, UUID FROM MDM_CUSTOM_FIELD_GROUP WHERE DISPLAY_NAME='%s' AND ASSET_PATH='%s'"
		if len(args) >= 2:
			self.cursor.execute(statement % (args[0], args[1]))
			rows = self.cursor.fetchall()
			return rows[0]
		return ""
	
	def backup(self, *args):
		if type(args[0]) == type(tuple()):
			args = args[0]
		if self.isDelete(args) or self.checkExistence(args[0:len(args)-1]):
			return (False, self.backUpExisting(args[0:len(args)-1]))
		else:
			return (True, (args[0:2]))
			
def main():
	#BaseClass.BaseClass.setCMSVersion("2.5.000.271")
	cfg = CustomFieldsGroups()
	#cfg.add("testscript", "PACKAGE/PREVIEW")
	#cfg.export("/tmp/cfg.tdf")
	cfg.add(("Custom Fields", "PACKAGE/ENCRYPTED",'asdfasfasfasdfasdfsa'))
	
if __name__ == "__main__":
	main()
