#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import socket
import urllib2

import httplib2
import os


class HttpRequestDecorator(object):
    APP_PEM = "/app.pem"
    CLIENTS_PEM = "/clients.pem"

    '''A simple wrapper for HTTP/URL request.'''
    @staticmethod
    def request(req_url, method="GET", body=None, headers=None):
        cms_haproxy_cert_path = os.getenv('CMS_HAPROXY_CERT_PATH')
        app_certs = cms_haproxy_cert_path + HttpRequestDecorator.APP_PEM
        clients_certs = cms_haproxy_cert_path + HttpRequestDecorator.CLIENTS_PEM

        h = httplib2.Http(".cache", ca_certs=app_certs, disable_ssl_certificate_validation=True, timeout=300)
        h.force_exception_to_status_code = True
        h.add_certificate(clients_certs, clients_certs, '')
        resp = h.request(req_url, method, body, headers)

        return resp
    
    @staticmethod
    def urlopen(url, data=None, timeout=socket._GLOBAL_DEFAULT_TIMEOUT):
        """Catches some unexpected errors raised by urllib2.urlopen which may need to be ignored."""
        resp = None
        max_num = 5
        
        for i in range(max_num):
            try:
                resp = urllib2.urlopen(url, data, timeout)
            except urllib2.URLError:
                # this may be an unexpected error which needs to be ignored
                print("An error of urllib2.URLError has been caught, ignore it %d/%d and retry..." % (i+1, max_num))
                pass
        
        return resp


def main():
    resp1 = HttpRequestDecorator.request("https://app:8443/cms/services/settings/com.tandbergtv.workflow.application")
    print(resp1)


if __name__ == '__main__':
    main()
