import json
import subprocess
from KubernetesConstants import *


class K8sUtil:

	APPLY_COMMAND = "kubectl patch %(type)s -n %(namespace)s %(name)s -p '%(jsonData)s'"
	FETCH_COMMAND = "kubectl get %(type)s -n %(namespace)s %(name)s -o json"

	@staticmethod
	def patch(k8s_resource_type, k8s_resource_name, key, value):
		jsonData = json.dumps({"data": {key: value}})
		command = K8sUtil.APPLY_COMMAND % \
			{'type': k8s_resource_type, 'namespace': CMS_NAMESPACE, 'name': k8s_resource_name, 'jsonData': jsonData}
		print "execute command: ", command
		success = os.system(command) == 0
		if not success:
			print "[WARN] Patching %(type)s %(name)s with key %(key)s failure." % \
				{'type': k8s_resource_type, 'name': k8s_resource_name, 'key': key}
		return success

	@staticmethod
	def getData(k8s_resource_type, k8s_resource_name, key=None):
		try:
			command = K8sUtil.FETCH_COMMAND % \
				{'type': k8s_resource_type, 'namespace': CMS_NAMESPACE, 'name': k8s_resource_name}
			p = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
			data, err = p.communicate()
			if err:
				print '[ERROR] subprocess failed: {}'.format(err)
				return False, {}
			result = json.loads(data)['data'] if 'data' in json.loads(data) else ''

			if key is not None:
				result = result[key] if key in result else ''

			return True, result
		except Exception as e:
			print "[WARN] Error while getting data from %(type)s %(name)s: %(ex)s" % \
				{'type': k8s_resource_type, 'name': k8s_resource_name, 'ex': e}
			return False, {}