#!/usr/bin/env python
import re
import sys
import BaseClass
import base64
from K8sUtil import *
from KubernetesConstants import *



class ProviderPropConfiguration(BaseClass.BaseHandler):

    def __init__(self):
        BaseClass.BaseHandler.__init__(self)
        self.content = ""
        self.secretKey = ""

    def checkExistence(self, data):
        self.secretKey = data[0]
        self.content = ""
        self.initContent()
        if len(self.content) == 0:
            return False
        hostRegex = r'(?<=[\r\n])[^#].*[(^|\s*)%s=]'
        return re.search(hostRegex % (data[1]), self.content) is not None

    def getNextId(self):
        return 0

    def insert(self, id_, data):
        try:
            print "[INFO] Adding provider properties configuration '%s' to in the secrets of '%s'..." % (data[1], EXTERNAL_CREDENTAIL_SECRET)
            self.content = self.content + "\n%s=%s" % (data[1], data[2])
            return K8sUtil.patch(SECRET, EXTERNAL_CREDENTAIL_SECRET, self.secretKey,
                                 base64.b64encode(self.content))
        except Exception:
            raise

    def initContent(self):
        success, data = K8sUtil.getData(SECRET, EXTERNAL_CREDENTAIL_SECRET, self.secretKey)
        if not success:
            print "[ERROR] Fetching existing secret key from %s failure, exit installation" % EXTERNAL_CREDENTAIL_SECRET
            sys.exit(1)
        if len(data) > 0:
            self.content = base64.b64decode(data)