#!/usr/bin/env python
import csv
from BaseHandler import BaseHandler


class CsvLikeFileHandler(BaseHandler):
    
    def __init__(self, dictData):
        BaseHandler.__init__(self, dictData)
        self.filePath = dictData.get('filePath')
        self.key = dictData.get('key')
        self.value = dictData.get('value')
        self.action = dictData.get('action')  
        self.config = self.loadFile()

    def loadFile(self):
        configDict = {}       
        with open(self.filePath) as f:
            reader = csv.reader(f)
            for row in reader:
                if row and not row[0].strip().startswith('#'):
                    configDict[row[0].strip()] = row[1].strip()
        return configDict

    def addEntry(self):
        if not self.key or not self.value:
            return
        if self.key in self.config:
            print 'Warning: Already exists the same key', self.key
            return
        
        with open(self.filePath, "a") as f:            
            fw = csv.writer(f)
            fw.writerow([self.key, self.value])
        print 'Add entry: ' + self.key + ',' + self.value
