#!/usr/bin/env python
import BaseClass
import ContentClassPartners
import base64
import json
from HttpRequestDecorator import HttpRequestDecorator
import urllib


class PartnersRestMgr(BaseClass.BaseHandler):
	PARTNER_SERVICE_LOCATION = "https://app:8443/services/partners"

	def __init__(self):
		BaseClass.BaseHandler.__init__(self)
		self.header = {'Accept': 'application/json', 'Content-Type': 'application/json'}
		print "PartnersRestMgr is initializing..."
			
	def listPartners(self):
		requestUrl = PartnersRestMgr.PARTNER_SERVICE_LOCATION
		return HttpRequestDecorator.request(requestUrl, "GET", None, headers=self.header)
	
	def listRelatedContentClass(self, data):
		partnerID = data[0]
		requestUrl = PartnersRestMgr.PARTNER_SERVICE_LOCATION + "/" + str(partnerID) + "/contentClasses"
		resp = HttpRequestDecorator.request(requestUrl, "GET", None, headers=self.header)
		if resp[0]["status"] != '200':
			print resp
			return False		
		contentClassesArr = []
		respPayload = json.loads(resp[1])  
		if respPayload["resourceList"] == "":
			return False		
		else:			
			contentClasses = respPayload["resourceList"]["contentClass"]			
			if type(contentClasses) is list: 
				for contentClass in contentClasses:
					contentClassesArr.append(contentClass["name"])	
			if type(contentClasses) is dict: 
				contentClassesArr.append(contentClasses["name"])	  
		return contentClassesArr
	
	def getPartnerByProviderID(self, data):
		# Fix issue of different behavior between PostgreSQL and Oracle on handling ""
		# In Oracle, it will treat "" as null when insert; However, in PostgreSQL, it will really insert "" treated as a value
		providerId = data[0]
		if providerId == "":
			return False
		resp = self.listPartners()
		if resp[0]["status"] != '200':
			print resp
			return False		
		print resp[1]
		respPayload = json.loads(resp[1])   
		if respPayload["resourceList"] == "":
			return False		
		else:		
			partnerInfo = respPayload["resourceList"]["partner"]			
			if type(partnerInfo) is list: 
				for partner in partnerInfo:					
					if partner["providerId"] == providerId:
						return partner				   
			if type(partnerInfo) is dict: 
				if partnerInfo["providerId"] == providerId:	  
					return partnerInfo			
		return False
	
	def getPartnerID(self, partner):
		partnerHref = partner["href"]
		partnerId = partnerHref[(partnerHref.rfind("/") + 1):]
		return partnerId	

	def checkExistence(self, data):		
		"""data: (PROVIDERID)"""
		partner = self.getPartnerByProviderID(data)
		if partner == False:
			return False
		else:
			return self.getPartnerID(partner)	   
			
	
	def buildPartnerBody(self, partnerRecord):
		partner = {}
		partnerBody = {}			
		partnerBody["providerId"] = partnerRecord[0]
		partnerBody["name"] = partnerRecord[1]
		partnerBody["type"] = partnerRecord[2]
		partnerBody["lookupKey"] = partnerRecord[3]
		partner["partner"] = partnerBody
		body = json.dumps(partner)
		return body			   
	
	def getNextId(self):
		"""this method is deprecated"""
		
	def insert(self, id_, data):
		"""data: (PROVIDERID,NAME,PARTNERTYPE,LOOKUPKEY,CONTENTCLASSNAME,IS_DELETE)"""
		print "insert partner "+str(data)
		cp = ContentClassPartners.ContentClassPartners()
		
		body = self.buildPartnerBody(data)
		resp = HttpRequestDecorator.request(PartnersRestMgr.PARTNER_SERVICE_LOCATION, "POST", body,
											headers=self.header)
		if resp[0]["status"] != '200':
			print resp
			return False
		try:
		 	providerId = data[0]
		 	""" To update contentClassPartners, 
			Step 1. Remove all association between content class partners and the specified providerId"""						
			cp.delete([providerId])
			
			"""Insert into content class partner table"""						
			for contentClass in data[4]:
				if not cp.checkExistence((providerId, contentClass)):
					cp.insert(providerId, contentClass)
			return True
		except Exception, e:
			print e
	   
	def update(self, data):
		"""data: (PROVIDERID, NAME,PARTNERTYPE,LOOKUPKEY,CONTENTCLASSNAME,IS_DELETE)"""
		print "update partner "+str(data)
		cp = ContentClassPartners.ContentClassPartners()	  
		partnerID = self.checkExistence(data)
		if partnerID == False:
			print "update: the partner '%s' doesn't exist!" % data[0]
			return False
		requestUrl = PartnersRestMgr.PARTNER_SERVICE_LOCATION + "/" + str(partnerID)
			   
		body = self.buildPartnerBody(data)

		resp = HttpRequestDecorator.request(requestUrl, "PUT", body, headers=self.header)
		if resp[0]["status"] != '200':
			print resp
			return False	
		try: 
			providerId = data[0]
			""" To update contentClassPartners, 
			Step 1. Remove all association between content class partners and the specified providerId"""						
			cp.delete([providerId])
			
			""" To update contentClassPartners, 
			Step 2. Insert new association between content class partners and the specified providerId"""		
			for contentClass in data[4]:
				if not cp.checkExistence((providerId, contentClass)):
					cp.insert(providerId, contentClass)			
		except Exception, e:
			print e
					
	def delete(self, data):
		"""
		data[0]: Provider Id

		"""
		print "delete partner "+str(data)
		providerId = data[0]		
		partnerID = self.checkExistence(data)
		if partnerID == False:
			return		
		try:
			requestUrl = PartnersRestMgr.PARTNER_SERVICE_LOCATION + "/" + str(partnerID)								
			# delete dependency firstly
			cp = ContentClassPartners.ContentClassPartners()
			cp.delete([providerId])
			
			# Make sure no title is associated with the partner, otherwise, can not delete
			resp = HttpRequestDecorator.request(requestUrl, "DELETE", None, headers=self.header)
			if resp[0]["status"] != '204':
				print resp
				return False   
		except Exception, e:
			print e
		
	def deleteDistributionPartner(self, partnerName, partnerType):
		# don't need this method anymore as the partner of distribution would be handled through site management.
		"""this delete method is only used to delete partner whose partner type is DISTRIBUTION"""

  	# args[2]: PROVIDERID list 
	def backUpExisting(self, args):	
		"""
		Input:
			args[0]: ProviderId
		"""	
		# UPDATE PMM_PARTNER SET NAME='%s', PARTNERTYPE='%s', LOOKUPKEY='%s' WHERE PROVIDERID='%s'
		if args[0] is None or not len(args[0]):
			return		
		
		providerId = args[0]
		partner = self.getPartnerByProviderID(args)
		
		partnerName = ""
		partnerType = ""
		if partner != False:
			partnerName = partner["name"]
			partnerType = partner["type"]
		partnerID = self.getPartnerID(partner)
		contentClasses = self.listRelatedContentClass([partnerID])
		result = [providerId, ] + [partnerName, partnerType] + [contentClasses, ]
		return result

        
def main():
	p = PartnersRestMgr()
	p.insert("4", ["testscript.com4", "testscript.com4", "SOURCE", "testscript.com4"])
	#p.delete(["testscript.com4", 4, "SOURCE", "testscript.com4"])
 	#p.export("/tmp/partners.tdf")
	# p.importFromFile("/tmp/partners.tdf")
	#p.backUpExisting(["testscript.com4"])
	
if __name__ == "__main__":
	main()
