#!/usr/bin/env python

from HttpRequestDecorator import HttpRequestDecorator
import sys
import json
import urllib

GET_ALL_RESOURCE_GROUPS_URL = "https://app:8443/v1/workflow/resourceGroups?display=all&count=500"
PATCH_RESOURCE_GROUP_URL = "https://app:8443/v1/workflow/resource-group/"


class ResourceGroupsRestMgr:

	def __init__(self):
		self.header = {'Content-Type': 'application/json', 'Accept': 'application/json'}
		self.__allResourceGroups = self.getAllResourceGroups()

	def getAllResourceGroups(self):
		resp = HttpRequestDecorator.request(GET_ALL_RESOURCE_GROUPS_URL, headers=self.header)
		if resp[0]["status"] != '200':
			print "[ERROR] Get all resource groups fail!\n", resp
			sys.exit(1)

		respJson = json.loads(resp[1])
		resourceGroups = {}
		resourceGroupsJsonArray = respJson.get("resourceGroups", [])
		for resourceGroupJson in resourceGroupsJsonArray:
			if "name" in resourceGroupJson:
				resourceGroups[resourceGroupJson.get("name")] = resourceGroupJson.get("isAllocatable")

		return resourceGroups

	def checkExistence(self, name):
		return name in self.__allResourceGroups

	def needUpdateAllocatable(self, name, allocatable):
		return allocatable != self.__allResourceGroups[name]

	def updateRGAllocation(self, *args):
		"""
		args[0]: NAME
		args[1]: ISALLOCATABLE
		"""
		if not self.checkExistence(args[0]):
			print "[INFO] Resource group '%s' is not existed." % (args[0])
			return

		if not self.needUpdateAllocatable(args[0], args[1]):
			return

		print "[INFO] Updating resource group %(name)s allocatable to %(allocatable)s" % \
			  {'name': args[0], 'allocatable': args[1]}

		body = json.dumps({"allocatable": args[1]})
		resp = HttpRequestDecorator.request(PATCH_RESOURCE_GROUP_URL + urllib.quote(args[0]), "PATCH", body, headers=self.header)
		if resp[0]["status"] != '200':
			print "[ERROR] Failed to update resource group allocatable:", resp
			sys.exit(1)

