#!/usr/bin/env python
import BaseClass
import ProcessDefinitions

class SelectorKeys(BaseClass.BaseClass):
	
	#		(0,	1,		   2,		 3,		)
	# data = (NAME, PARTNERTYPE, CONTEXTID, PROVIDERID)
	
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "SELECTIONKEY, PROCESSDEFINITIONID"
		self.table = "TTV_SELECTOR"
		#self.setSelectStatement()
		self.selectStatement = "SELECT S.SELECTIONKEY, PD.NAME_ "\
								"FROM TTV_SELECTOR S "\
								"JOIN JBPM_PROCESSDEFINITION PD "\
								"ON (S.PROCESSDEFINITIONID = PD.ID_)"


	def checkExistence(self, data):
		key = data[0]
		self.cursor.execute("SELECT * FROM TTV_SELECTOR WHERE SELECTIONKEY='%s'" % key)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		try:
			(selectorKey, templateName) = (data[0], data[1])
			templateExists, processDefinitionId = self.validateAndGetTemplateIdValid(templateName, selectorKey)
			
			if not templateExists or processDefinitionId is None:
				return
			
			statement = "INSERT INTO TTV_SELECTOR (SELECTIONKEY, PROCESSDEFINITIONID) VALUES %s" % self.tupleToStr([selectorKey, processDefinitionId])
			print statement
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def update(self, data):
		try:
			self.delete(data)
			(selectorKey, templateName) = (data[0], data[1])
			templateExists, processDefinitionId = self.validateAndGetTemplateIdValid(templateName, selectorKey)
			
			if not templateExists or processDefinitionId is None:
				return
			
			statement = "INSERT INTO TTV_SELECTOR (SELECTIONKEY, PROCESSDEFINITIONID) VALUES %s" % self.tupleToStr([selectorKey, processDefinitionId])
			print statement
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
	
	def delete(self, data):
		"""delete the association between selector keys and template
		data[0]: selctor key
		data[1]: template name
		"""
		try:
			key = data[0]
			statement = "DELETE FROM TTV_SELECTOR WHERE SELECTIONKEY='%s'" % (key)
			print statement
			self.cursor.execute(statement)
			
			return self.commit()		
		except Exception, e:
			print e
			return self.rollback()
	
	#data:  ["SELECTIONKEY","TEMPLATE"]	
	def backUpExisting(self, args):		
		#UPDATE PMM_PARTNER SET NAME='%s', PARTNERTYPE='%s', LOOKUPKEY='%s' WHERE PROVIDERID='%s'
		if args is None or not len(args):
			return 
		statement =  "SELECT SELECTIONKEY, NAME_ FROM TTV_SELECTOR,JBPM_PROCESSDEFINITION WHERE PROCESSDEFINITIONID = ID_ AND SELECTIONKEY ='%s'" % args[0]
		print statement
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		return rows[0] 
	
	def validateAndGetTemplateIdValid(self, templateName, selectorKey):
		processDefinitionId = ProcessDefinitions.ProcessDefinitions().checkExistence(tuple([templateName]))
		if processDefinitionId is None or processDefinitionId is False:
			print "[Error] " + templateName + " does not ingest yet! Cannot associate selector keys to it, please try to associate " \
					+ selectorKey + " to it manually after installation"
			return	(False, None)
		
		return (True, processDefinitionId)	
			
def main():
	sk = SelectorKeys()
	#sk.add("120112", "Content Processing Template")
	sk.export("/tmp/selectorkeys.tdf")
	
if __name__ == "__main__":
	main()