#!/bin/sh

PREFERENCES_PATH="/opt/tandbergtv/cms/workflow/preferences"

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
mkpProfile="${PREFERENCES_PATH}/dist-mkp.xml"
mkpWithMFProfile="${PREFERENCES_PATH}/dist-mkp-with-mf.xml"
MediaFirstStatusPlugin_Config="/opt/tandbergtv/cms/plugins/site/monitoring/MediaFirstDistribution/config/mf-client.properties"
mfClientWithMFProfile="${PREFERENCES_PATH}/dist-mediafirst-client-sample.xml"

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${mkpProfile} ]; then
  echo "Upgrading $mkpProfile"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $mkpProfile -k /properties/entry[@key=\'site.associatedResources\'] -v "MFVP Packaging"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${mkpWithMFProfile} ]; then
  echo "Upgrading $mkpWithMFProfile"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $mkpWithMFProfile -k /properties/entry[@key=\'site.associatedResources\'] -v "MFVP Packaging"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${mfClientWithMFProfile} ]; then
  echo "Upgrading $mfClientWithMFProfile"
  python "${MIGRATION_TOOL_PATH}" -a REMOVE-ENTRY-VALUE -f $mfClientWithMFProfile -k /properties/entry[@key=\'dist.steps\'] -v "Check_Dependency"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${MediaFirstStatusPlugin_Config} ]; then
  echo "Upgrading $MediaFirstStatusPlugin_Config"
  if egrep 'ENDPOINT_URL.*com....' "${MediaFirstStatusPlugin_Config}" >/dev/null 2>&1; then
    echo \"MediaFirstStatusPlugin_Config\" had been added the path.
  else
    sed -i "s#^\(ENDPOINT_URL.*com\).*#\1/S1/discovery/v3/titles/%s#g" ${MediaFirstStatusPlugin_Config}
  fi
fi