<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">


<xsl:template name="SignalGroupType">
<!-- "Fields/Avails/Avail/TimeCodeTwo(Three)/Value" fields are created and copied by the SpecHandler from the corresponding TimeCode fields.
      They are temporary fields which will be removed after xslt transformation. The same is true for "Fields/Avails/Avail/TimeCodeTwo(Three)/Identifier/Id" fields
      used for storing UUID (generated by SpecHandler).  
-->
<xsl:if test="$Movie/Fields/Avails/Avail/TimeCodeTwo/Value or $Movie/Fields/Avails/Avail/TimeCodeThree/Value">
	<xsl:variable name="ProviderVersionNum" select="1"/>
	<xsl:variable name="internalVersionNum" select="0"/>
	<SignalGroup>
		<xsl:attribute name="uriId">
			<xsl:value-of select="$TitleUriId"/>
		</xsl:attribute>
		<xsl:attribute name="providerVersionNum">
			<xsl:value-of select="$ProviderVersionNum"/>
		</xsl:attribute>
		<xsl:attribute name="internalVersionNum">
			<xsl:value-of select="$internalVersionNum"/>
		</xsl:attribute>
		<xsl:if test="$Title/Fields/Rights/LicensingWindowStart">
			<xsl:attribute name="startDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowStart"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>	
	
		<xsl:if test="$Title/Fields/Rights/LicensingWindowEnd">
			<xsl:attribute name="endDateTime">
				<xsl:call-template name="endDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/Rights/LicensingWindowEnd"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="$Title/Fields/CreationInfo/CreateDate">
			<xsl:attribute name="creationDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/Fields/CreationInfo/CreateDate"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
	
	<xsl:apply-templates select="$Movie/Fields/Avails/Avail"/>    
	</SignalGroup>

</xsl:if>
</xsl:template>


<xsl:template match="Movie/Fields/Avails/Avail">
  <xsl:variable name="frameRate">
		<xsl:value-of select="$Movie/Fields/Content/FrameRate"/>
  </xsl:variable>
  <xsl:if test="TimeCodeTwo/Value or TimeCodeThree/Value">
  <signaling:SignalRegion>	
			<xsl:if test="TimeCodeTwo/Value">
				<xsl:variable name="tcValue" select="TimeCodeTwo/Value"/>
				<signaling:StartPoint>
					<xsl:attribute name="signalPointID">
						<xsl:value-of select="TimeCodeTwo/Identifier/Id"/>
					</xsl:attribute>
					<signaling:NPTPointDescriptor>
						<xsl:attribute name="nptPoint">
							<xsl:choose>
								<xsl:when test="$tcValue = 'BOS' or $tcValue = 'bos'">
									<xsl:value-of select="0"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="contains($tcValue,':')">
				            				<xsl:call-template name="tcDurationInSecs">
				            					<xsl:with-param name="timeCode" select="$tcValue" />
				            					<xsl:with-param name="frameRate" select="$frameRate" />
				            				</xsl:call-template>																	
										</xsl:when>
										<xsl:otherwise>										
											<xsl:value-of select="$tcValue"/>
										</xsl:otherwise>							
									</xsl:choose>
						   		</xsl:otherwise>							
							</xsl:choose>
					    </xsl:attribute>			
					</signaling:NPTPointDescriptor>
				</signaling:StartPoint>
			</xsl:if>
			<xsl:if test="TimeCodeThree/Value">
				<xsl:variable name="tcValue" select="TimeCodeThree/Value"/>
				<signaling:EndPoint>
					<xsl:attribute name="signalPointID">
						<xsl:value-of select="TimeCodeThree/Identifier/Id"/>
					</xsl:attribute>
					<signaling:NPTPointDescriptor>
						<xsl:attribute name="nptPoint">
							<xsl:choose>
								<xsl:when test="TimeCodeThree/Value = 'EOS' or $tcValue = 'eos'">
									<xsl:value-of select="0"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="contains($tcValue,':')">
				            				<xsl:call-template name="tcDurationInSecs">
				            					<xsl:with-param name="timeCode" select="$tcValue" />
				            					<xsl:with-param name="frameRate" select="$frameRate" />
				            				</xsl:call-template>																	
										</xsl:when>
										<xsl:otherwise>										
											<xsl:value-of select="$tcValue"/>
										</xsl:otherwise>							
									</xsl:choose>
						    	</xsl:otherwise>							
							</xsl:choose>
						</xsl:attribute>			
					</signaling:NPTPointDescriptor>
				</signaling:EndPoint>
			</xsl:if>
  </signaling:SignalRegion>
  </xsl:if>
</xsl:template>


</xsl:stylesheet>